/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 *                Copyright (C) 2006 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */
#ifndef _SPU_PSGL_h
#define _SPU_PSGL_h

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PSGL_READ_TAG 30		// DMA tag used by psglSPUReadMappedBuffer
#define PSGL_WRITE_TAG 31		// DMA tag used by psglSPUWriteMappedBuffer

void psglSPUInit(unsigned long long initAddr);
void psglSPUWriteMappedBuffer(unsigned long long mappedAddress,const void* localAddress,size_t size);
void psglSPUReadMappedBuffer(unsigned long long mappedAddress,void* localAddress,size_t size);
void glSetMappedEventSCE(unsigned long long event);
void glSetMappedEventWithAddressTagSCE(unsigned long long event, unsigned int *zeroBuffer, unsigned int tag);

#ifdef __cplusplus
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _SPU_PSGL_h
