/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_READY_COUNT_H__
#define __CELL_SPURS_READY_COUNT_H__ 1

/* The C Standard Library */
#include <stdint.h>

/* SPURS */
#include <cell/spurs/types.h>
#include <cell/spurs/error.h>

#ifdef __cplusplus
extern "C" {
#endif

int cellSpursReadyCountSwap(
	unsigned char *ls, uint64_t eaSpurs, CellSpursWorkloadId id,
	unsigned *old, unsigned value);

int cellSpursReadyCountCompareAndSwap(
	unsigned char *ls, uint64_t eaSpurs, CellSpursWorkloadId id,
	unsigned *old, unsigned compare, unsigned swap);

int cellSpursReadyCountAdd(
	unsigned char *ls, uint64_t eaSpurs, CellSpursWorkloadId id,
	unsigned *old, int value);

#ifdef __cplusplus
} /* extern "C" */
#endif

static inline
int cellSpursReadyCountStore(
	unsigned char *ls, uint64_t eaSpurs, CellSpursWorkloadId id,
	unsigned value)
{
	unsigned old;
	return cellSpursReadyCountSwap(ls, eaSpurs, id, &old, value);
}

#endif /* __CELL_SPURS_READY_COUNT_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
