/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2005 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/


#ifndef __CELL_SYNC_QUEUE_H__
#define __CELL_SYNC_QUEUE_H__

#include <stdint.h>
#include <cell/sync/error.h>


#define CELL_SYNC_QUEUE_MINIMUM_BUFFER_SIZE 128

typedef	union _CellSyncQueueHead {
#ifdef __GNUC__
	__extension__
#endif
	struct _CellSyncQueueHeadStr {
		uint64_t rlock        :  8;  
		uint64_t index        : 24;
		uint64_t wlock        :  8;  
		uint64_t size         : 24;  
	} asStr;
	uint64_t asUint;
} _CellSyncQueueHead;
	

typedef struct  _CellSyncQueue {
	_CellSyncQueueHead head;
	uint32_t           buffer_size;
	uint32_t           depth;
	uint64_t           addr_buffer;
	uint64_t           _padding;
} CellSyncQueue;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


int
cellSyncQueueInitialize(uint64_t ea, 
						uint64_t ptr_buffer, 
						uint32_t buffer_size, 
						unsigned int depth,
						unsigned int tag);


int
cellSyncQueuePush(uint64_t ptr_obj,  const void *buf, 
				  unsigned int tag);

int  
cellSyncQueueTryPush(uint64_t ptr_obj, 
					 const void *buf,
					 unsigned int tag);

int
cellSyncQueuePop(uint64_t ptr_obj, 
				 void *buf,
				 unsigned int tag);

int  
cellSyncQueueTryPop(uint64_t ptr_obj, 
					void *buf,
					unsigned int tag);


int
cellSyncQueueSize(uint64_t ea);

int
cellSyncQueueClear(uint64_t ea);


int
cellSyncQueuePeek(uint64_t ptr_obj, 
				  void *buf,
				  unsigned int tag);

int
cellSyncQueueTryPeek(uint64_t ptr_obj, 
					 void *buf,
					 unsigned int tag);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __CELL_SYNC_QUEUE_H__ */








