/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 1998-2005 CRI-MW
 *
 * Library  : CRI Middleware Library
 * Module   : CRI Common Header for PS3 PPU
 * File     : cri_xpts_ps3ppu.h
 * Date     : 2005-08-09
 * Version  : 1.01
 *
 ****************************************************************************/
#ifndef CRI_XPTS_PS3PPU_H
#define CRI_XPTS_PS3PPU_H

#include <sdk_version.h>

#ifndef SEGA_XPT_H

/*****************************************************************************
 * 萔}N
 *****************************************************************************/

/* NULL |C^^ */
#ifndef NULL
#ifdef __cplusplus
#define NULL	(0)
#else
#define NULL	((void *)0)
#endif
#endif

/* _萔PiUA^j */
#ifndef FALSE
#define FALSE	(0)
#endif
#ifndef TRUE
#define TRUE	(1)
#endif

/* _萔QiXCb`j */
#ifndef OFF
#define OFF		(0)
#endif
#ifndef ON
#define ON		(1)
#endif

/* ʔ̒萔iAsj */
#ifndef OK
#define OK		(0)			/*  */
#endif
#ifndef NG
#define NG		(-1)		/* s */
#endif

/*****************************************************************************
 * {f[^^錾
 *****************************************************************************/

#ifndef _TYPEDEF_Uint8
#define _TYPEDEF_Uint8
typedef unsigned char			Uint8;		/* ȂPoCg */
#endif

#ifndef _TYPEDEF_Sint8
#define _TYPEDEF_Sint8
typedef signed char				Sint8;		/* PoCg */
#endif

#ifndef _TYPEDEF_Uint16
#define _TYPEDEF_Uint16
typedef unsigned short			Uint16;		/* ȂQoCg */
#endif

#ifndef _TYPEDEF_Sint16
#define _TYPEDEF_Sint16
typedef signed short			Sint16;		/* QoCg */
#endif

#ifndef _TYPEDEF_Uint32
#define _TYPEDEF_Uint32
typedef unsigned int			Uint32;		/* ȂSoCg */
#endif

#ifndef _TYPEDEF_Sint32
#define _TYPEDEF_Sint32
typedef signed int				Sint32;		/* SoCg */
#endif


#if (CELL_SDK_VERSION >= 0x080000)

#ifndef _TYPEDEF_Uint64
#define _TYPEDEF_Uint64
typedef unsigned long long		Uint64;		/* ȂWoCg */
#endif

#ifndef _TYPEDEF_Sint64
#define _TYPEDEF_Sint64
typedef signed long long		Sint64;		/* WoCg */
#endif

#else

#ifndef _TYPEDEF_Uint64
#define _TYPEDEF_Uint64
typedef unsigned long			Uint64;		/* ȂWoCg */
#endif

#ifndef _TYPEDEF_Sint64
#define _TYPEDEF_Sint64
typedef signed long				Sint64;		/* WoCg */
#endif

#endif


#ifndef _TYPEDEF_Uint128
#define _TYPEDEF_Uint128
typedef struct {							/* Ȃ16oCg */
	Uint64			h;						/* 64rbg */
	Uint64			l;						/* 64rbg */
} Uint128;
#endif

#ifndef _TYPEDEF_Sint128
#define _TYPEDEF_Sint128
typedef struct {							/* 16oCg */
	Sint64	h;								/* 64rbg */
	Uint64	l;								/* 64rbg */
} Sint128;
#endif

#ifndef _TYPEDEF_Float16
#define _TYPEDEF_Float16
typedef signed short			Float16;	/* QoCg */
#endif

#ifndef _TYPEDEF_Float32
#define _TYPEDEF_Float32
typedef float					Float32;	/* SoCg */
#endif

#ifndef _TYPEDEF_Float64
#define _TYPEDEF_Float64
typedef double					Float64;	/* WoCg */
#endif

#ifndef _TYPEDEF_Fixed32
#define _TYPEDEF_Fixed32
typedef signed int				Fixed32;	/* Œ菬_32rbg */
#endif

#ifndef _TYPEDEF_Bool
#define _TYPEDEF_Bool
typedef Sint32					Bool;		/* _^i_萔lɂƂj */
#endif

#ifndef _TYPEDEF_Char8
#define _TYPEDEF_Char8
typedef char					Char8;		/* ^ */
#endif

/*****************************************************************************
 * |C^ϐ
 *****************************************************************************/
#if (CELL_SDK_VERSION >= 0x080000)

#ifndef _TYPEDEF_SintPtr
#define _TYPEDEF_SintPtr
typedef Sint32					SintPtr;
#endif

#ifndef _TYPEDEF_UintPtr
#define _TYPEDEF_UintPtr
typedef Uint32					UintPtr;
#endif

#else

#ifndef _TYPEDEF_SintPtr
#define _TYPEDEF_SintPtr
typedef Sint64					SintPtr;
#endif

#ifndef _TYPEDEF_UintPtr
#define _TYPEDEF_UintPtr
typedef Uint64					UintPtr;
#endif

#endif
/*****************************************************************************
 * xNgϐ
 *****************************************************************************/
#ifndef _TYPEDEF_Svec8
#define _TYPEDEF_Svec8
typedef vector signed char			Svec8;
#endif

#ifndef _TYPEDEF_Uvec8
#define _TYPEDEF_Uvec8
typedef vector unsigned char		Uvec8;
#endif

#ifndef _TYPEDEF_Svec16
#define _TYPEDEF_Svec16
typedef vector signed short			Svec16;
#endif

#ifndef _TYPEDEF_Uvec16
#define _TYPEDEF_Uvec16
typedef vector unsigned short		Uvec16;
#endif

#ifndef _TYPEDEF_Svec32
#define _TYPEDEF_Svec32
typedef vector signed int			Svec32;
#endif

#ifndef _TYPEDEF_Uvec32
#define _TYPEDEF_Uvec32
typedef vector unsigned int			Uvec32;
#endif

#ifndef _TYPEDEF_Fvec32
#define _TYPEDEF_Fvec32
typedef vector float				Fvec32;
#endif

/*****************************************************************************
 * ĂяoK
 *****************************************************************************/

#ifndef CRIAPI
#define CRIAPI
#endif	/* endif CRIAPI */


#endif
#endif	/* CRI_XPTS_PS3PPU_H */

/* end of file */
