/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2003-2004 CRI-MW
 *
 *	Appli.	: ADX Library
 *	Module	: ADX Cinematic Sound System sample
 *	File	: adxcsply.c
 *
 ***************************************************************************/

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <stdio.h>
#include <string.h>

#include <cri_mw.h>
#include <cri_ut.h>
#include "usr/usr.h"


/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/*	BGM				*/
/*	The number of BGM	*/
#define	NUM_BGM		(2)

/*	ő`l				*/
/*	The number of maximum channels	*/
#define	MAX_CH		(2)

/*	ĐőXg[									*/
/*	The number of maximum disc streams playing at the same time	*/
#define	MAX_STM		(2)

/*	ōTvOg		*/
/*	Maximum sampling frequency	*/
#define	MAX_SFREQ	(48000)

/*	őgbN		*/
/*	The number of maximum tracks	*/
#define	MAX_TRACK	(4)

/*	tF[hAEg	*/
/*	Fade-out time		*/
#define FADE_OUT_TIME				(180)			/*	3sec	*/
/*	tF[hC	*/
/*	Fade-in time		*/
#define FADE_IN_TIME				(180)			/*	3sec	*/
/*	{[ύX	*/
/*	Volume change time	*/
#define VOL_CHANGE_TIME				(180)			/*	3sec	*/
/*	tF[hCJnItZbg	*/
/*	Fade-in start offset		*/
#define FADE_IN_START_OFFSET		(0)
/*	tF[h̃fBC	*/
/*	Fade-end delay				*/
#define FADE_END_DELAY				(ADXCS_DEF_FADE_END_DELAY)

/*	{CXnCCg̃{[		*/
/*	Volume decrease time of Voice-Highlight		*/
#define VHL_DEC_TIME				(30)			/*	0.5sec	*/
/*	{CXnCCg̃{[	*/
/*	Volume increase time of Voice-Highlight	*/
#define VHL_INC_TIME				(60)			/*	1sec	*/
/*	{CXnCCg̃{[			*/
/*	Volume decrease amount of Voice-Highlight	*/
#define VHL_DEC_VOL					(120)			/*	12dB	*/

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*	tOON/OFF̔]		*/
/*	Turn over flag(ON/OFF)	*/
#define NOT_FLAG(flag)		(((flag) == OFF) ? ON : OFF)

/*	gpϐ		*/
/*	Unused variable	*/
#define UNUSED(val)			((val) = (val))

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/

/***************************************************************************
 *      ϐ錾
 *      Prototype Functions
 ***************************************************************************/
/*	AvP[V\											*/
/*	Application structure											*/
typedef struct {
	Sint32	disp_flag;				/*	Display information flag	*/
	ADXCS 	adxcs_bgm;				/*	ADXCS handle				*/
	ADXCS 	adxcs_voice;			/*	ADXCS handle				*/
	Sint8 	*work_bgm;				/*	Work area					*/
	Sint8 	*work_voice;			/*	Work area					*/
	Sint32	fname_index;			/*	Index of filename array		*/
	Char8	*fname_bgm[NUM_BGM];	/*	BGM Filenames				*/
	Char8	*fname_voice;			/*	Voice Filenames				*/
} AP_OBJ;

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
void ap_adx_err_func(void *obj, Char8 *msg);
void ap_disp_info(AP_OBJ *ap);
void ApInitMw(AP_OBJ *ap);
void ApFinishMw(AP_OBJ *ap);
void ApStart(AP_OBJ *ap);
void ApStop(AP_OBJ *ap);
Sint32 ApExec(AP_OBJ *ap);

/***************************************************************************
 *      ϐ`
 *      Variable Declarations
 ***************************************************************************/
/*	AvP[VIuWFNg								*/
/*	Application Object											*/
AP_OBJ ap_obj = {
	ON,							/*	Display information flag	*/
	NULL,						/*	ADXCS handle				*/
	NULL,						/*	Work area					*/
	NULL,						/*	ADXCS handle				*/
	NULL,						/*	Work area					*/
	0,							/*	Index of filename array		*/
	{
		"music48a.adx",			/*	ADX file name				*/
		"music48b.adx",			/*	ADX file name				*/
	},
	"voice24a.ahx"				/*	AHX file name				*/
};

/***************************************************************************
 *      ֐`
 *      Function Declarations
 ***************************************************************************/

/*	ADXTG[ɋN֐					*/
/*	Callback function when an error occur in ADXT	*/
void ap_adx_err_func(void *obj, Char8 *msg)
{
	UNUSED(obj);	/*	Unused variable	*/

	UsrDbgPrintf(msg);

	for (;;) {		/*	[Xɂ͖					*/
		;			/*	Delete when you release application.	*/
	}
}

/*	~hEFȀ				*/
/*	Initialize Middleware				*/
void ApInitMw(AP_OBJ *ap)
{
	UNUSED(ap);	/*	Unused variable	*/

	/*	ADXCu		*/
	/*	Initialize ADX library	*/
	ADXT_Init();

	/*	ADXCS			*/
	/*	Initialize ADXCS	*/
	ADXCS_Init();

	/*	{CXnCCg̃{[Ԃݒ	*/
	/*	Set volume decrease time of Voice-Highlight	*/
	ADXCS_SetVhlDecTime(VHL_DEC_TIME);
	/*	{CXnCCg̃{[Ԃݒ	*/
	/*	Set volume increase time of Voice-Highlight	*/
	ADXCS_SetVhlIncTime(VHL_INC_TIME);
	/*	{CXnCCg̃{[ʂݒ		*/
	/*	Set volume deccrease amount of Voice-Highlight	*/
	ADXCS_SetVhlDecVol(VHL_DEC_VOL);

	/*	{CXnCCgLɂ	*/
	/*	Enable Voice-Highlight			*/
	ADXCS_EnableVhl();
}

/*	~hEFȀI					*/
/*	Finalize Middleware					*/
void ApFinishMw(AP_OBJ *ap)
{
	UNUSED(ap);	/*	Unused variable	*/

	ADXCS_Finish();

	ADXT_Finish();
}

/*	AvP[VJn	*/
/*	Start application			*/
void ApStart(AP_OBJ *ap)
{
	AdxcsCrePrm cprm;
	Sint32 work_size;

	ap->adxcs_bgm	= NULL;
	ap->adxcs_voice	= NULL;

	/*	ADXCS nh̐	*/
	/*	Create ADXCS handle		*/
	memset(&cprm, 0, sizeof(cprm));
	cprm.max_stm		= MAX_STM;
	cprm.max_ch			= MAX_CH;
	cprm.max_sfreq		= MAX_SFREQ;
	cprm.max_aix_track	= MAX_TRACK;
	cprm.play_method	= ADXT_PLY_STM;
	cprm.sound_type		= ADXCS_SND_TYPE_BGM;
	cprm.use_crossfade	= TRUE;
	cprm.use_ahx		= FALSE;
	cprm.use_aix		= FALSE;
	
	/*	BGM	*/
	work_size = ADXCS_CalcWorkCprm(&cprm);
	ap->work_bgm = (Sint8 *)UsrMalloc((Uint32)work_size);
	ap->adxcs_bgm = ADXCS_Create(&cprm, ap->work_bgm, work_size);
	if (ap->adxcs_bgm == NULL) {
		ap_adx_err_func(NULL, "can't create ADXCS \n");
		for (;;) ;
	}
	if (cprm.use_ahx == TRUE) {
		ADXCS_AttachAhx(ap->adxcs_bgm);
	}

	/*	VOICE	*/
	cprm.sound_type		= ADXCS_SND_TYPE_VOICE;
	cprm.use_ahx		= TRUE;
	work_size = ADXCS_CalcWorkCprm(&cprm);
	ap->work_voice = (Sint8 *)UsrMalloc((Uint32)work_size);
	ap->adxcs_voice = ADXCS_Create(&cprm, ap->work_voice, work_size);
	if (ap->adxcs_voice == NULL) {
		ap_adx_err_func(NULL, "can't create ADXCS \n");
		for (;;) ;
	}
	if (cprm.use_ahx == TRUE) {
		ADXCS_AttachAhx(ap->adxcs_voice);
	}

	/*	tF[hAEgԂ̐ݒ	*/
	/*	Set fade-out time			*/
	ADXCS_SetFadeOutTime(ap->adxcs_bgm, FADE_OUT_TIME);
	/*	tF[hCԂ̐ݒ	*/
	/*	Set fade-in time		*/
	ADXCS_SetFadeInTime(ap->adxcs_bgm, FADE_IN_TIME);
	/*	tF[h{[ύXԂ̐ݒ	*/
	/*	Set volume change time				*/
	ADXCS_SetVolChangeTime(ap->adxcs_bgm, VOL_CHANGE_TIME);
	/*	tF[hCJnItZbg̐ݒ	*/
	/*	Set fade-in start offset			*/
	ADXCS_SetFadeInStartOffset(ap->adxcs_bgm, FADE_IN_START_OFFSET);
	/*	tF[hIfBC̐ݒ	*/
	/*	Set fade-end delay				*/
	ADXCS_SetFadeEndDelay(ap->adxcs_bgm, FADE_END_DELAY);
	ADXCS_SetFadeEndDelay(ap->adxcs_voice, 0);

	/*	ĐJn		*/
	/*	Start to play	*/
	ADXCS_StartFname(ap->adxcs_bgm, ap->fname_bgm[ap->fname_index]);
}

/*	AvP[V~	*/
/*	Stop application			*/
void ApStop(AP_OBJ *ap)
{
	const AdxcsCrePrm	*cprm;
	cprm = ADXCS_GetCprm(ap->adxcs_voice);
	if (cprm->use_ahx == TRUE) {
		ADXCS_DetachAhx(ap->adxcs_voice);
	}

	/*	ADXT nh̏	*/
	/*	Destroy ADXT handle	*/
	ADXCS_Destroy(ap->adxcs_voice);
	ADXCS_Destroy(ap->adxcs_bgm);
	UsrFree(ap->work_voice);
	UsrFree(ap->work_bgm);
	ap->adxcs_bgm = NULL; 
	ap->adxcs_voice = NULL; 
}

/*	̕\			*/
/*	Display infomation	*/
void ap_disp_info(AP_OBJ *ap)
{
	char 		*ststr[] =
		{"STOP   ", "PREP   ", "PLAYING", "DECEND ", "PLAYEND"};
	Sint32		stat, sfreq, cnt;
	Sint32		hh, mm, ss, ff;
	Sint32		vol;
	ADXT		adxt;
	const AdxcsCrePrm	*cprm;
	
	UsrPrintf(3, 3, "ADX Sample Program");
	UsrPrintf(3, 4, "   ADX Cinematic Sound Sample ");

	/*	BGM̏̕\				*/
	/*	Display information of BGM	*/
	stat = ADXCS_GetStat(ap->adxcs_bgm);

	UsrPrintf(3,  6, "FILE = %s", ap->fname_bgm[ap->fname_index]);
	UsrPrintf(3,  7, "STAT = %s (%d)", ststr[stat], stat);

	cprm = ADXCS_GetCprm(ap->adxcs_bgm);
	if (cprm->use_aix == TRUE) {
		adxt = AIXP_GetAdxt(ADXCS_GetActiveAixp(ap->adxcs_bgm), 0);
	} else {
		adxt = ADXCS_GetActiveAdxt(ap->adxcs_bgm);
	}
	ADXT_GetTime(adxt, &cnt, &sfreq);
	UsrSfcnt2time(sfreq,  cnt, &hh, &mm, &ss, &ff);
	UsrPrintf(3,  8, "TIME = %2d:%02d:%02d.%02d", hh, mm, ss, ff);

	vol = ADXT_GetOutVol(adxt);
	UsrPrintf(3,  10, "BGM Vol   = %-3d", vol);

	/*	Voicȅ̕\				*/
	/*	Display information of Voice	*/
	cprm = ADXCS_GetCprm(ap->adxcs_voice);
	if (cprm->use_aix == TRUE) {
		adxt = AIXP_GetAdxt(ADXCS_GetActiveAixp(ap->adxcs_voice), 0);
	} else {
		adxt = ADXCS_GetActiveAdxt(ap->adxcs_voice);
	}
	vol = ADXT_GetOutVol(adxt);
	UsrPrintf(3,  11, "Voice Vol = %-3d", vol);
}

/*	AvP[VC	*/
/*	Run application				*/
Sint32 ApExec(AP_OBJ *ap)
{
	const USR_PERIPHERAL	*per;

	if (ap->disp_flag == ON) {
		ap_disp_info(ap);
	}

	per = UsrGetPeripheral(0);	
	if (per->press & UTPAD_L) {
		ap->disp_flag = NOT_FLAG(ap->disp_flag);
	}
	if (per->press & UTPAD_BUTTON1) {
		ap->fname_index = 0;
		ADXCS_StartFname(ap->adxcs_bgm, ap->fname_bgm[ap->fname_index]);
	}
	if (per->press & UTPAD_BUTTON2) {
		ap->fname_index = 1;
		ADXCS_StartFname(ap->adxcs_bgm, ap->fname_bgm[ap->fname_index]);
	}
	if (per->press & UTPAD_BUTTON3) {
		ADXCS_StartFname(ap->adxcs_voice, ap->fname_voice);
	}
	if (per->press & UTPAD_BUTTON4) {
		ADXCS_Stop(ap->adxcs_voice);
	}
	if (per->press & UTPAD_DOWN) {
		ADXCS_SetOutVol(ap->adxcs_bgm, ADXT_MIN_OUTVOL);
	}
	if (per->press & UTPAD_UP) {
		ADXCS_SetOutVol(ap->adxcs_bgm, ADXT_MAX_OUTVOL);
	}
	if (per->press & UTPAD_START) {
		return FALSE;
	}

	if (ADXCS_GetStat(ap->adxcs_bgm) == ADXCS_STAT_PLAYEND) {
		return FALSE;
	}

	/* CRI Middleware Library's Server function */
	ADXM_ExecMain();

	return TRUE;
}


/***
 *		C
 *		MAIN
 ***/
int main(void)
{
	AP_OBJ	*ap;
	Sint32	term_flag = OFF;
	Bool	ret;
	
	ap = &ap_obj;

	/*	G[R[obN֐̓o^		*/
	/*	Entry ADX error callback function	*/
	ADXM_SetCbErr(ap_adx_err_func, NULL);
	
	/*	VXȅ										*/
	/*	Initialize System										*/
	UsrInitSystem(NULL, NULL);
	
	/*	rfȈ											*/
	/*	Initialize Video System									*/
	UsrInitVideo(NULL, NULL);
	
	/*	TEh̏										*/
	/*	Initialize Sound System									*/
	UsrInitSound(NULL, NULL);

	ApInitMw(ap);

	while (term_flag == OFF) {
		ApStart(ap);
		/*	cnt :frame count						*/
		/*	cnt=0:interlace	/ cnt>0:non interlace	*/
		UsrInitSync(2);
		for (;;) {
			UsrSyncFrame();
			UsrBeginDraw();
			ret = ApExec(ap);
			UsrEndDraw();

			/* I邩ǂ̊mF					*/
			/* Checks whether Usr module is terminated	*/
			if (UsrIsTerminated() == TRUE) {
				term_flag = ON;
			}
			
			if (ret == FALSE || term_flag == ON) {
				break;
			}
		}
		ApStop(ap);
	}
	/*	AvP[VI	*/
	/*	Finalize application		*/
	ApFinishMw(ap);			/*	~hEFȀI				*/
							/*	Finalize Middleware				*/
	UsrFinishSound();		/*	TEhVXȅI		*/
							/*	Finalize sound system			*/
	UsrFinishVideo();		/*	rfȈI				*/
							/*	Finalize Video system			*/
	UsrFinishSystem();		/*	VXȅI				*/
							/*	Finalize system					*/
	return 0;
}

/* end of file */
