/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2004 CRI-MW
 *
 * Appli.   : ADXT Sample Program 
 * Module   : Main function.(Playing Single ADX File)
 * File     : adxgdply.c
 *
 ****************************************************************************/


/***************************************************************************
 *		CN[ht@C
 *		Include file
 ***************************************************************************/
#include <stdio.h>

#include <cri_mw.h>
#include <cri_ut.h>
#include "usr/usr.h"

/***************************************************************************
 *		萔}N
 *		Constant Macro
 ***************************************************************************/
/*	ő`l				*/
/*	The number of maximum channels	*/
#define	MAX_CH		(2)

/*	ĐőXg[									*/
/*	The number of maximum disc streams playing at the same time	*/
#define	MAX_STM		(1)

/*	ōTvOg		*/
/*	Maximum sampling frequency	*/
#define	MAX_SFREQ	(48000)

/*	t@CĐp[N̈̑傫	*/
/*	Work area size of CD stream play	*/
#define WKSIZE		ADXT_CALC_WORK(MAX_CH, ADXT_PLY_STM, MAX_STM, MAX_SFREQ)

/***************************************************************************
 *		}N
 *		Process MACRO
 ***************************************************************************/
/*	tOON/OFF̔]		*/
/*	Turn over flag(ON/OFF)	*/
#define NOT_FLAG(flag)		(((flag) == OFF) ? ON : OFF)

#define UNUSED(val)			((val) = (val))

/***************************************************************************
 *		ϐ`
 *		Variable Definition
 ***************************************************************************/
/*	AvP[V\											*/
/*	Application structure											*/
typedef struct {
	Sint32	disp_flag;			//	Display information flag
	char	*fname;				//	File name
	ADXT 	adxt;				//	ADXT handle
	Sint8 	wk[WKSIZE];			//	Work area
} AP_OBJ;

/*	AvP[VIuWFNg									*/
/*	Application Object												*/
AP_OBJ ap_obj = {
	ON,							//	Sint32	disp_flag;
	"music48a.adx",				//	ADX file name
	NULL						//	ADXT handle
};

/***************************************************************************
 *		֐錾
 *		Function Declaration
 ***************************************************************************/
void ap_adx_err_func(void *obj, Char8 *msg);
void ap_disp_info(AP_OBJ *ap);
void ApInitMw(AP_OBJ *ap);
void ApFinishMw(AP_OBJ *ap);
void ApStart(AP_OBJ *ap);
void ApStop(AP_OBJ *ap);
Sint32 ApExec(AP_OBJ *ap);

/***************************************************************************
 *		֐`
 *		Function Definition
 ***************************************************************************/

/*	ADXTG[ɋN֐					*/
/*	Callback function when an error occur in ADXT	*/
void ap_adx_err_func(void *obj, Char8 *msg)
{
	UNUSED(obj);		// gpϐ

	UsrDbgPrintf(msg);

	for (;;) {		/*	[Xɂ͖					*/
		;			/*	Delete when you release application.	*/
	}
}

/*	~hEFȀ				*/
/*	Initialize Middleware				*/
void ApInitMw(AP_OBJ *ap)
{
	UNUSED(ap);	// gpϐ

	/*	ADXCu		*/
	/*	Initialize ADX library	*/
	ADXT_Init();
}

/*	~hEFȀI					*/
/*	Finalize Middleware					*/
void ApFinishMw(AP_OBJ *ap)
{
	UNUSED(ap);	// gpϐ

	ADXT_Finish();
}

/*	AvP[VJn	*/
/*	Start application			*/
void ApStart(AP_OBJ *ap)
{
	ap->adxt	= NULL;

	/*	ADXT nh̐	*/
	/*	Create ADXT handle	*/
	ap->adxt = ADXT_Create(2, ap->wk, WKSIZE);
	if (ap->adxt == NULL) {
		printf("can't create ADXT \n");
		for (;;) ;
	}

	/*	ĐJn		*/
	/*	Start to play	*/
	ADXT_StartFname(ap->adxt, ap->fname);
}

/*	AvP[V~	*/
/*	Stop application			*/
void ApStop(AP_OBJ *ap)
{
	/*	ADXT nh̏	*/
	/*	Destroy ADXT handle	*/
	ADXT_Destroy(ap->adxt);
	ap->adxt = NULL; 
}

/*	̕\			*/
/*	Display infomation	*/
void ap_disp_info(AP_OBJ *ap)
{
	char 		*ststr[] =
		{"STOP   ", "DECINFO", "PREP   ", "PLAYING", "DECEND ", "PLAYEND"};
	Sint32		stat, sfreq, cnt;
	Sint32		hh, mm, ss, ff;
	
	UsrPrintf(3, 3, "ADX Sample Program");
	UsrPrintf(3, 4, "   ADX Playing Single-Stream");

	stat = ADXT_GetStat(ap->adxt);

	UsrPrintf(3,  6, "FILE = %s", ap->fname);
	UsrPrintf(3,  7, "STAT = %s (%d)", ststr[stat], stat);
	ADXT_GetTime(ap->adxt, &cnt, &sfreq);
	UsrSfcnt2time(sfreq,  cnt, &hh, &mm, &ss, &ff);
	UsrPrintf(3,  8, "TIME = %2d:%02d:%02d.%02d", hh, mm, ss, ff);

}

/*	AvP[VC	*/
/*	Run application				*/
Sint32 ApExec(AP_OBJ *ap)
{
	const USR_PERIPHERAL	*per;

	if (ap->disp_flag == ON) {
		ap_disp_info(ap);
	}

	per = UsrGetPeripheral(0);	
	if (per->press & UTPAD_L) {
		ap->disp_flag = NOT_FLAG(ap->disp_flag);
	}
	if (per->press & UTPAD_BUTTON1) {
		return FALSE;
	}

	if (ADXT_GetStat(ap->adxt) == ADXT_STAT_PLAYEND) {
		return FALSE;
	}

	/* CRI Middleware Library's Server function */
	ADXM_ExecMain();

	return TRUE;
}


/***
 *		C
 *		MAIN
 ***/
int main(void)
{
	AP_OBJ	*ap;
	Sint32	term_flag = OFF;
	Bool	ret;
	
	ap = &ap_obj;

	/*	G[R[obN֐̓o^		*/
	/*	Entry ADX error callback function	*/
	ADXM_SetCbErr(ap_adx_err_func, NULL);
	
	/*	VXȅ										*/
	/*	Initialize System										*/
	UsrInitSystem(NULL, NULL);
	
	/*	rfȈ											*/
	/*	Initialize Video System									*/
	UsrInitVideo(NULL, NULL);
	
	/*	TEh̏										*/
	/*	Initialize Sound System									*/
	UsrInitSound(NULL, NULL);

	ApInitMw(ap);

	while (term_flag == OFF) {
		ApStart(ap);
		/*	cnt :frame count						*/
		/*	cnt=0:interlace	/ cnt>0:non interlace	*/
		UsrInitSync(2);
		for (;;) {
			UsrSyncFrame();
			UsrBeginDraw();
			ret = ApExec(ap);
			UsrEndDraw();

			/* I邩ǂ̊mF					*/
			/* Checks whether Usr module is terminated	*/
			if (UsrIsTerminated() == TRUE) {
				term_flag = ON;
			}
			
			if (ret == FALSE || term_flag == ON) {
				break;
			}
		}
		ApStop(ap);
	}
	/*	AvP[VI	*/
	/*	Finalize application		*/
	ApFinishMw(ap);			/*	~hEFȀI				*/
							/*	Finalize Middleware				*/
	UsrFinishSound();		/*	TEhVXȅI		*/
							/*	Finalize sound system			*/
	UsrFinishVideo();		/*	rfȈI				*/
							/*	Finalize Video system			*/
	UsrFinishSystem();		/*	VXȅI				*/
							/*	Finalize system					*/
	return 0;
}

/* end of file */
