/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2001-2004 CRI-MW
 *
 *	Appli.	: CRI Middleware Sample Program
 *	Module	: Users Functions Header
 *	File	: usr.h
 *	Date	: 2004-09-02
 *
 ***************************************************************************/

#ifndef INCLUDED_USR_H		/* Re-definition prevention */
#define INCLUDED_USR_H

/***************************************************************************
 *		CN[ht@C
 *		Include Files
 ***************************************************************************/
#include <cri_ut.h>

/***************************************************************************
 *		萔}N
 *		Constant Macros
 ***************************************************************************/

/* pbh͂̎				*/
/* Kind of inputs of peripheral	*/
#define USR_PD_UP			UTPAD_UP
#define USR_PD_DOWN			UTPAD_DOWN
#define USR_PD_LEFT			UTPAD_LEFT
#define USR_PD_RIGHT		UTPAD_RIGHT
#define USR_PD_BUTTON1		UTPAD_BUTTON1
#define USR_PD_BUTTON2		UTPAD_BUTTON2
#define USR_PD_BUTTON3		UTPAD_BUTTON3
#define USR_PD_BUTTON4		UTPAD_BUTTON4
#define USR_PD_L			UTPAD_L
#define USR_PD_R			UTPAD_R
#define USR_PD_START		UTPAD_START

/* pbh̃|[gԍ			*/
/* Port number of peripherals	*/
#define USR_PD_PORT_MAX		UTPAD_PORT_MAX
#define USR_PD_PORT1		UTPAD_PORT1
#define USR_PD_PORT2		UTPAD_PORT2

/***************************************************************************
 *		}N
 *		Process Macros
 ***************************************************************************/

/***************************************************************************
 *		f[^^錾
 *		Data Type Declarations
 ***************************************************************************/
/* pbh			*/
/* Peripheral states	*/
typedef struct { 
	Uint32	on; 
	Uint32	press; 
	Sint16	x1; 
	Sint16	y1; 
} USR_PERIPHERAL; 

/***************************************************************************
 *		ϐ錾
 *		Variable Declarations
 ***************************************************************************/

/***************************************************************************
 *		֐錾
 *		Function Declarations
 ***************************************************************************/
#ifdef  __cplusplus
extern "C" {					/* __cplusplus */
#endif

/***
 *		System Functions
 ***/

/* VXȅ			*/
/* Initialize the system	*/
void UsrInitSystem(const void *in, void *out);

/* VXȅI		*/
/* Finalize the system	*/
void UsrFinishSystem(void);


/***
 *		Video Functions
 ***/

/* rfIVXȅ		*/
/* Initialize the video system	*/
void UsrInitVideo(const void *in, void *out);

/* rfIVXȅI			*/
/* Finalize the video system	*/
void UsrFinishVideo(void);

/* `Jn			*/
/* Start drawing	*/
void UsrBeginDraw(void);

/* `I		*/
/* End drawing	*/
void UsrEndDraw(void);

/* VBlank҂		*/
/* Wait a Vblank	*/
void UsrWaitVBlank(void);

/* VXȅ						*/
/* Initialize the synchronization system	*/
/*	cnt :frame count						*/
/*	cnt=0:interlace	/ cnt>0:non interlace	*/
void UsrInitSync(Sint32 cnt);

/* t[			*/
/* Synchronize frame	*/
void UsrSyncFrame(void);


/***
 *		Audio Functions
 ***/

/* TEhVXȅ		*/
/* Initialize the sound system	*/
void UsrInitSound(const void *in, void *out);

/* TEhVXȅI		*/
/* Finalize the sound system	*/
void UsrFinishSound(void);


/***
 *		Drawing Movie Functions
 ***/
/* [r[f[^̃eNX`ւ̓]	*/
/* Load movie frame for Sofdec			*/
void UsrLoadMvFrm(Uint8 *bufadr, Sint32 sx, Sint32 sy);

/* [r[t[̕`	*/
/* Draw Movie frame			*/
void UsrDrawMv(void);


/***
*		Peripheral Functions
***/

/* pbh擾			*/
/* Get peripheral states	*/
const USR_PERIPHERAL* UsrGetPeripheral(Uint32 port);


/***
 *		Utility Functions
 ***/

/* m			*/
/* Allocate memory		*/
void *UsrMalloc(Uint32 size);

/* J	*/
/* Free memory	*/
void UsrFree(void *ptr);

/* VsyncJEgl̎擾	*/
/* Get Vsync count			*/
Uint32 UsrGetVcount(void);

/* fobO\			*/
/* Print string for debug	*/
Sint32 UsrPrintf(Sint32 lx, Sint32 ly, const Char8 *fmt, ...);

/* fobOFݒ	*/
/* Set text color		*/
void UsrSetColor(Uint8 r, Uint8 g, Uint8 b);

/* XN[TCY̎擾	*/
/* Get size of screen		*/
void UsrGetMetrix(Sint32 *w, Sint32 *h);

/* fobOo		*/
/* Output string for debug	*/
Sint32 UsrDbgPrintf(const Char8 *fmt, ...);

/* IɃf[^[h	*/
/* Load data to memory				*/
void *UsrLoadFile(const Char8 *fname, Sint32 *len);

/* C^[X[r[peNX`[h^C~O	*/
/* Check timing of loading texture for interlace movie	*/
Bool UsrIsLoadTiming(void);

/* g[I[vXe[^X`FbN	*/
/* Check door status				*/
Bool UsrIsDoorOpen(void);

/* ̕ϊ																*/
/* Convert from sampling frequency and counter to time(hour,min,sec,frame)	*/
void UsrSfcnt2time(Sint32 sf, Sint32 ncnt, 
					Sint32 *hh, Sint32 *mm, Sint32 *ss, Sint32 *ff);

/* ̎擾(usecP)		*/
/* Get time as micro sec	*/
Uint32 UsrGetTimeMicro(void);

/* G[\[v	*/
/* Error loop		*/
void UsrErrLoop(const Char8 *fmt, ...);

/* I邩ǂ̊mF					*/
/* Check whether Usr module is terminated	*/
Bool UsrIsTerminated();

#ifdef  __cplusplus
}
#endif

#endif	/* #ifndef INCLUDED_USR_H */
