/***************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2004 CRI-MW
 *
 * Appli.   : ADXT Sample Program 
 * Module   : Main function.(Playing Multi-streams)
 * File     : adxmlt.c
 *
 ***************************************************************************/

/***************************************************************************
 *		CN[ht@C
 *		Include file
 ***************************************************************************/

#include <stdio.h>

#include <cri_mw.h>
#include "usr/usr.h"

/***************************************************************************
 *		萔}N
 *		Constant Macro
 ***************************************************************************/
/*	The number of ADXT handles	*/
#define	NADXT		(4)

/*	ő`l				*/
/*	The number of maximum channels	*/
#define	MAX_CH		(2)

/*	ĐőXg[									*/
/*	The number of maximum disc streams playing at the same time	*/
#define	MAX_STM		(NADXT)

/*	ōTvOg		*/
/*	Maximum sampling frequency	*/
#define	MAX_SFREQ	(48000)

/*	t@CĐp[N̈̑傫	*/
/*	Work area size of disc stream play	*/
#define	WKSIZE		(ADXT_CALC_WORK(MAX_CH, 1, MAX_STM, MAX_SFREQ))

/***************************************************************************
 *		}N
 *		Process MACRO
 ***************************************************************************/

/*	tOON/OFF̔]		*/
/*	Turn over flag(ON/OFF)	*/
#define NOT_FLAG(flag)		(((flag) == OFF) ? ON : OFF)

#define UNUSED(val)			((val) = (val))

/***************************************************************************
 *		ϐ`
 *		Variable Definition
 ***************************************************************************/
/*	AvP[V\											*/
/*	Application structure											*/
typedef struct {
	Sint32	disp_flag;				//	Display information flag
	Sint32	pause_flag;				//	Pause flag
	ADXT	adxt[NADXT];			//	ADXT handle
	char	*fname[NADXT];			//	File name
	Sint8	work[NADXT][WKSIZE];	//	Work area
} AP_OBJ;

/*	AvP[VIuWFNg									*/
/*	Application Object												*/
AP_OBJ ap_obj = {
	ON,							//	Display Info.
	OFF,						//	not puase
	{NULL, NULL, NULL, NULL},	//	ADXT handle
	{
		"music48a.adx",
		"voice48a.adx",
		"voice48b.adx",
		"voice48c.adx"
	},
};

/***************************************************************************
 *		֐錾
 *		Function Declaration
 ***************************************************************************/
void ap_adx_err_func(void *obj, Char8 *msg);
void ap_disp_info(AP_OBJ *ap);
void ApInitMw(AP_OBJ *ap);
void ApFinishMw(AP_OBJ *ap);
void ApStart(AP_OBJ *ap);
void ApStop(AP_OBJ *ap);
Sint32 ApExec(AP_OBJ *ap);

/***************************************************************************
 *		֐`
 *		Function Definition
 ***************************************************************************/

/***
 *			TvvO
 *			Sample program
 ***/

/*	ADXTG[ɋN֐					*/
/*	Callback function when an error occur in ADXT	*/
void ap_adx_err_func(void *obj, Char8 *msg)
{
	UNUSED(obj);		// gpϐ

	UsrDbgPrintf(msg);

	for (;;) {		/*	[Xɂ͖					*/
		;			/*	Delete when you release application.	*/
	}
}

/*	~hEFȀ				*/
/*	Initialize Middleware				*/
void ApInitMw(AP_OBJ *ap)
{
	UNUSED(ap);	// gpϐ

	/*	ADXCu		*/
	/*	Initialize ADX library	*/
	ADXT_Init();
}

/*	AvP[VJn	*/
/*	Start application		*/
void ApStart(AP_OBJ *ap)
{
	Sint32	i;

	/*	ADXT nh̐	*/
	/*	Create ADXT handle	*/
	for (i = 0; i < NADXT; i++) {
		if ((ap->adxt[i]=ADXT_Create(2, ap->work[i], WKSIZE)) == NULL)
			for (;;) ;
	}
	
	/*	ĐJn		*/
	/*	Start to play	*/
	for (i = 0; i < NADXT; i++) {
		ADXT_StartFname(ap->adxt[i], ap->fname[i]);
	}
}

/*	AvP[V~	*/
/*	Stop application		*/
void ApStop(AP_OBJ *ap)
{
	Sint32	i;

	/*	ADXT nh̏	*/
	/*	Destroy ADXT handle	*/
	for (i = 0; i < NADXT; i++) {
		ADXT_Destroy(ap->adxt[i]);
		ap->adxt[i] = NULL;
	}
}

/*	̕\			*/
/*	Display infomation	*/
void ap_disp_info(AP_OBJ *ap)
{
	char			*ststr[6] =
		{"STOP   ", "DECINFO", "PREP   ", "PLAYING", "DECEND ", "PLAYEND"};
	Sint32			stat, sfreq, cnt, i, vol;
	Sint32			hh, mm, ss, ff;

	UsrPrintf(3, 3, "ADX Sample Program");
	UsrPrintf(3, 4, "   ADX Playing Multi-Stream");
	for (i = 0; i < NADXT; i++) {
		stat = ADXT_GetStat(ap->adxt[i]);
		UsrPrintf(3, 6+i*2, "ADXT%2d: Stat=%s", i, ststr[stat]);
		ADXT_GetTime(ap->adxt[i], &cnt, &sfreq);
		UsrSfcnt2time(sfreq,  cnt, &hh, &mm, &ss, &ff);
		vol = ADXT_GetOutVol(ap->adxt[i]);
		UsrPrintf(24, 6+i*2, "Time=%d:%02d:%02d.%02d %s",
								hh, mm, ss, ff, (vol == 0) ? "ON  " : "MUTE");
	}
}

/*	ADFX̍Đ			*/
/*	Playing the ADXT	*/
Sint32 ApExec(AP_OBJ *ap)
{
	Sint32					i;
	const USR_PERIPHERAL	*per;

	/*	̕\			*/
	/*	Display infomation	*/
	ap_disp_info(ap);

	per = UsrGetPeripheral(0);
	
	if (per->press & UTPAD_BUTTON1)
		ADXT_StartFname(ap->adxt[0], ap->fname[0]);
	if (per->press & UTPAD_BUTTON2)
		ADXT_StartFname(ap->adxt[1], ap->fname[1]);
	if (per->press & UTPAD_BUTTON3)
		ADXT_StartFname(ap->adxt[2], ap->fname[2]);
	if (per->press & UTPAD_BUTTON4)
		ADXT_StartFname(ap->adxt[3], ap->fname[3]);
	if (per->press & UTPAD_R) {
		for (i = 0; i < NADXT; i++)
			ADXT_SetOutVol(ap->adxt[i], -960);
		ADXT_SetOutVol(ap->adxt[0], 0);
	}
	if (per->press & UTPAD_UP) {
		for (i = 0; i < NADXT; i++)
			ADXT_SetOutVol(ap->adxt[i], -960);
		ADXT_SetOutVol(ap->adxt[1], 0);
	}
	if (per->press & UTPAD_RIGHT) {
		for (i = 0; i < NADXT; i++)
			ADXT_SetOutVol(ap->adxt[i], -960);
		ADXT_SetOutVol(ap->adxt[2], 0);
	}
	if (per->press & UTPAD_DOWN) {
		for (i = 0; i < NADXT; i++)
			ADXT_SetOutVol(ap->adxt[i], -960);
		ADXT_SetOutVol(ap->adxt[3], 0);
	}
	if (per->press & UTPAD_LEFT) {
		for (i = 0; i < NADXT; i++)
			ADXT_SetOutVol(ap->adxt[i], 0);
	}
	if (per->press & UTPAD_START) {
		for (i = 0; i < NADXT; i++)
			ADXT_Stop(ap->adxt[i]);
	}
	
	/* CRI Middleware Library's Server function */
	ADXM_ExecMain();

	return TRUE;
}

/*	~hEFȀI					*/
/*	Finalize Middleware					*/
void ApFinishMw(AP_OBJ *ap)
{
	UNUSED(ap);	// gpϐ

	ADXT_Finish();
}

/***
 *		C
 *		MAIN
 ***/
int main(void)
{
	AP_OBJ	*ap;
	Sint32	term_flag = OFF;
	Bool	ret;

	ap = &ap_obj;

	/*	G[R[obN֐̓o^		*/
	/*	Entry ADX error callback function	*/
	ADXM_SetCbErr(ap_adx_err_func, NULL);
	
	/*	VXȅ										*/
	/*	Initialize System										*/
	UsrInitSystem(NULL, NULL);
	
	/*	rfȈ											*/
	/*	Initialize Video System									*/
	UsrInitVideo(NULL, NULL);
	
	/*	TEh̏										*/
	/*	Initialize Sound System									*/
	UsrInitSound(NULL, NULL);

	ApInitMw(ap);

	while (term_flag == OFF) {
		ApStart(ap);
		/*	cnt :frame count						*/
		/*	cnt=0:interlace	/ cnt>0:non interlace	*/
		UsrInitSync(2);
		for (;;) {
			UsrSyncFrame();
			UsrBeginDraw();
			ret = ApExec(ap);
			UsrEndDraw();

			/* I邩ǂ̊mF					*/
			/* Checks whether Usr module is terminated	*/
			if (UsrIsTerminated() == TRUE) {
				term_flag = ON;
			}
			
			if (ret == FALSE || term_flag == ON) {
				break;
			}
		}
		ApStop(ap);
	}
	/*	AvP[VI	*/
	/*	Finalize application		*/
	ApFinishMw(ap);			/*	~hEFȀI				*/
							/*	Finalize Middleware				*/
	UsrFinishSound();		/*	TEhVXȅI		*/
							/*	Finalize sound system			*/
	UsrFinishVideo();		/*	rfȈI				*/
							/*	Finalize Video system			*/
	UsrFinishSystem();		/*	VXȅI				*/
							/*	Finalize system					*/
	return 0;
}

/* end of file */
