/***************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2004 CRI-MW
 *
 * Appli.   : ADXT Sample Program 
 * Module   : Main function.(ADX File system - Asynchronous reading)
 * File     : adxrdnw.c
 *
 ***************************************************************************/

/***************************************************************************
 *		CN[ht@C
 *		Include file
 ***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <cri_mw.h>

#include "usr/usr.h"
#include "data.h"

/***************************************************************************
 *		萔}N
 *		Constant Macro
 ***************************************************************************/
/*	p[eBVhc	*/
/*	Partition ID		*/
#define	PATID			(0)

/*	p[eBV̍őt@C			*/
/*	The number of maximum files in partition	*/
#define	MAX_NFILES		(5)

/*	őADXFnh						*/
/*	The number of maximum ADXF handles		*/
#define	MAX_ADXF		(5)

/*	ő`l				*/
/*	The number of maximum channels	*/
#define	MAX_CH			(2)

/*	ĐőXg[									*/
/*	The number of maximum disc streams playing at the same time	*/
#define	MAX_STM			(1)

/*	ōTvOg		*/
/*	Maximum sampling frequency	*/
#define	MAX_SFREQ		(48000)

/*	t@CĐp[N̈̑傫	*/
/*	Work area size of disc stream play	*/
#define WKSIZE			ADXT_CALC_WORK(MAX_CH, 1, MAX_STM, MAX_SFREQ)

/*	t@Cǂݍݗp[N̈̑傫	*/
/*	Work area size of reading data			*/
#define	PTINFOSIZE		(ADXF_CALC_PTINFO_SIZE(MAX_NFILES))

/***************************************************************************
 *		}N
 *		Process MACRO
 ***************************************************************************/
/*	tOON/OFF̔]		*/
/*	Turn over flag(ON/OFF)	*/
#define NOT_FLAG(flag)		(((flag) == OFF) ? ON : OFF)

#define UNUSED(val)			((val) = (val))

/***************************************************************************
 *		ϐ`
 *		Variable Definition
 ***************************************************************************/
/*	AvP[V\											*/
/*	Application structure											*/
typedef struct {
	Sint32	disp_flag;			//	Display information flag
	char	*afsfname;				//	AFS file name
	char	*adxfname;				//	ADX file name
	ADXF	adxf[MAX_ADXF];			//	ADXF handle
	ADXT	adxt;					//	ADXT handle
	Uint8	ptinfo[PTINFOSIZE];		//	Partition infomation area
	Uint8	work[WKSIZE];			//	Work area
	Uint8	*data_buf;				//	Data buffer
	Uint8	*malloc_adr;			//	malloc address
} AP_OBJ;

/*	AvP[VIuWFNg									*/
/*	Application Object												*/
AP_OBJ ap_obj = {
	ON,							//	Sint32	disp_flag;
	"data.afs",					//	AFS file name
	"bgmlp48a.adx",				//	ADX file name
};

/***************************************************************************
 *		֐錾
 *		Function Declaration
 ***************************************************************************/
void ap_adx_err_func(void *obj, Char8 *msg);
void ap_disp_info(AP_OBJ *ap);
void ap_clear_data(AP_OBJ *ap);
void ApInitMw(AP_OBJ *ap);
void ApFinishMw(AP_OBJ *ap);
void ApStart(AP_OBJ *ap);
void ApStop(AP_OBJ *ap);
Sint32 ApExec(AP_OBJ *ap);

/***************************************************************************
 *		֐`
 *		Function Definition
 ***************************************************************************/

/*	ADXTG[ɋN֐					*/
/*	Callback function when an error occur in ADXT	*/
void ap_adx_err_func(void *obj, Char8 *msg)
{
	UNUSED(obj);		// gpϐ

	UsrDbgPrintf(msg);

	for (;;) {		/*	[Xɂ͖					*/
		;			/*	Delete when you release application.	*/
	}
}

/*	~hEFȀ				*/
/*	Initialize Middleware				*/
void ApInitMw(AP_OBJ *ap)
{
	UNUSED(ap);	// gpϐ

	/*	ADXCu		*/
	/*	Initialize ADX library	*/
	ADXT_Init();
}

/*	~hEFȀI					*/
/*	Finalize Middleware					*/
void ApFinishMw(AP_OBJ *ap)
{
	UNUSED(ap);	// gpϐ

	ADXT_Finish();
}

/*	f[^̈̃NA	*/
/*	Clear data area		*/
void ap_clear_data(AP_OBJ *ap)
{
	memset(ap->data_buf, 'x', 100*2048);
}

/*	AvP[VJn	*/
/*	Start application			*/
void ApStart(AP_OBJ *ap)
{
	/*	p[eBV̓ǂݍ	*/
	/*	Load partition infomation		*/
	memset(ap->ptinfo, 0, sizeof(ap->ptinfo));
	ADXF_LoadPartitionNw(PATID, ap->afsfname, NULL, ap->ptinfo);
	for (;;) {
		if (ADXF_GetPtStat(PATID) == ADXF_STAT_READEND) {
			break;
		}
		ADXM_ExecMain();
		ADXM_WaitVsync();
	}
	/*	f[^ǂݍݗ̈̊m			*/
	/*	Allocate buffer for reading data	*/
	ap->malloc_adr = UsrMalloc(100*2048 + 63);

	ap->data_buf = (Uint8 *)(((UintPtr)(ap->malloc_adr) + 63) & 0xffffffc0);
	ap_clear_data(ap);

	/*	AFSt@C̃I[v	*/
	/*	Open AFS file			*/
	if ((ap->adxf[0]=ADXF_OpenAfs(PATID, TEST1_BIN)) == NULL) {
		for (;;) ;
	}
	if ((ap->adxf[1]=ADXF_OpenAfs(PATID, TEST2_BIN)) == NULL) {
		for (;;) ;
	}
	if ((ap->adxf[2]=ADXF_OpenAfs(PATID, TEST3_BIN)) == NULL) {
		for (;;) ;
	}
	if ((ap->adxf[3]=ADXF_OpenAfs(PATID, TEST4_BIN)) == NULL) {
		for (;;) ;
	}
	if ((ap->adxf[4]=ADXF_OpenAfs(PATID, TEST5_BIN)) == NULL) {
		for (;;) ;
	}

	/*	ADXt@CĐpnh̐		*/
	/*	Create ADXT handle					*/
	if ((ap->adxt=ADXT_Create(2, ap->work, WKSIZE)) == NULL) {
		for (;;) ;
	}
	/*	ĐJn		*/
	/*	Start to play	*/
	ADXT_StartFname(ap->adxt, ap->adxfname);

}

/*	AvP[V~	*/
/*	Stop application			*/
void ApStop(AP_OBJ *ap)
{
	Sint32	i;

	/*	ADXT nh̏	*/
	/*	Destroy ADXT handle	*/
	ADXT_Destroy(ap->adxt);
	ap->adxt = NULL;

	/*	AFSt@C̃N[Y	*/
	/*	Close AFS file			*/
	for (i = 0; i < MAX_ADXF; i++) {
		ADXF_Close(ap->adxf[i]);
		ap->adxf[i] = NULL;
	}

	UsrFree(ap->malloc_adr);
	ap->malloc_adr	= NULL;
	ap->data_buf	= NULL;

}

/*	̕\			*/
/*	Display infomation	*/
void ap_disp_info(AP_OBJ *ap)
{
	Sint32	i, j;
	char 	*ststr[5] = {"    ", "STOP", "READ", "END ", "ERR "};

	UsrPrintf(3, 3, "ADXF Sample Program");
	UsrPrintf(3, 4, "   (Reading data with playing ADX)");

	for (i = 0; i < 12; i++) {
		for (j = 0; j < 32; j++)
			UsrPrintf(3 + j, 6 + i, "%c", ap->data_buf[i*2048*5+j]);
	}

	for (i = 0; i < MAX_ADXF; i++) {
		UsrPrintf(40, 6 + i, "%s", ststr[ADXF_GetStat(ap->adxf[i])]);
	}
}

/*	AvP[VC	*/
/*	Run application				*/
Sint32 ApExec(AP_OBJ *ap)
{
	const USR_PERIPHERAL	*per;
	ADXF					adxf[MAX_ADXF];

	adxf[0] = ap->adxf[0];
	adxf[1] = ap->adxf[1];
	adxf[2] = ap->adxf[2];
	adxf[3] = ap->adxf[3];
	adxf[4] = ap->adxf[4];

	if (ap->disp_flag == ON)
		ap_disp_info(ap);
			
	per = UsrGetPeripheral(0);
	if (per->press & UTPAD_START)
		ap_clear_data(ap);

	if (per->press & UTPAD_L)
		ap->disp_flag = NOT_FLAG(ap->disp_flag);

	if (per->press & UTPAD_UP)
		return FALSE;

	/*	AFSt@C̓ǂݍ݊Jn	*/
	/*	Start to load AFS file		*/
	if (per->press & UTPAD_BUTTON1) {
		if (ADXF_Tell(adxf[0]) == ADXF_GetFsizeSct(adxf[0]))
			ADXF_Seek(adxf[0], 0, ADXF_SEEK_SET);
		ADXF_ReadNw(adxf[0], 100, ap->data_buf);
	}
	if (per->press & UTPAD_BUTTON2) {
		if (ADXF_Tell(adxf[1]) == ADXF_GetFsizeSct(adxf[1]))
			ADXF_Seek(adxf[1], 0, ADXF_SEEK_SET);
		ADXF_ReadNw(adxf[1], 100, ap->data_buf);
	}
	if (per->press & UTPAD_BUTTON3) {
		if (ADXF_Tell(adxf[2]) == ADXF_GetFsizeSct(adxf[2]))
			ADXF_Seek(adxf[2], 0, ADXF_SEEK_SET);
		ADXF_ReadNw(adxf[2], 100, ap->data_buf);
	}
	if (per->press & UTPAD_BUTTON4) {
		if (ADXF_Tell(adxf[3]) == ADXF_GetFsizeSct(adxf[3]))
			ADXF_Seek(adxf[3], 0, ADXF_SEEK_SET);
		ADXF_ReadNw(adxf[3], 100, ap->data_buf);
	}
	if (per->press & UTPAD_R) {
		if (ADXF_Tell(adxf[4]) == ADXF_GetFsizeSct(adxf[4]))
			ADXF_Seek(adxf[4], 0, ADXF_SEEK_SET);
		ADXF_ReadNw(adxf[4], 100, ap->data_buf);
	}

	/* CRI Middleware Library's Server function */
	ADXM_ExecMain();

	return TRUE;
}

/***
 *		C
 *		MAIN
 ***/
int main(void)
{
	AP_OBJ	*ap;
	Sint32	term_flag = OFF;
	Bool	ret;

	ap = &ap_obj;

	/*	G[R[obN֐̓o^		*/
	/*	Entry ADX error callback function	*/
	ADXM_SetCbErr(ap_adx_err_func, NULL);
	
	/*	VXȅ										*/
	/*	Initialize System										*/
	UsrInitSystem(NULL, NULL);
	
	/*	rfȈ											*/
	/*	Initialize Video System									*/
	UsrInitVideo(NULL, NULL);
	
	/*	TEh̏										*/
	/*	Initialize Sound System									*/
	UsrInitSound(NULL, NULL);

	ApInitMw(ap);

	while (term_flag == OFF) {
		ApStart(ap);
		/*	cnt :frame count						*/
		/*	cnt=0:interlace	/ cnt>0:non interlace	*/
		UsrInitSync(2);
		for (;;) {
			UsrSyncFrame();
			UsrBeginDraw();
			ret = ApExec(ap);
			UsrEndDraw();

			/* I邩ǂ̊mF					*/
			/* Checks whether Usr module is terminated	*/
			if (UsrIsTerminated() == TRUE) {
				term_flag = ON;
			}
			
			if (ret == FALSE || term_flag == ON) {
				break;
			}
		}
		ApStop(ap);
	}
	/*	AvP[VI	*/
	/*	Finalize application		*/
	ApFinishMw(ap);			/*	~hEFȀI				*/
							/*	Finalize Middleware				*/
	UsrFinishSound();		/*	TEhVXȅI		*/
							/*	Finalize sound system			*/
	UsrFinishVideo();		/*	rfȈI				*/
							/*	Finalize Video system			*/
	UsrFinishSystem();		/*	VXȅI				*/
							/*	Finalize system					*/
	return 0;
}
