#if !defined 	SPUPAGES_SPUPAGES_H__
#define			SPUPAGES_SPUPAGES_H__

#include <types.h>


namespace spupages
{
	class SPUPage
	{
	public:
		SPUPage();
		~SPUPage();

	
		bool SetELF( const char* elfFileName );

		bool SetParam( uint32_t index, uint32_t param );

		const uint8_t*	GetDMABuffer() const { return m_dmaBuffer; }
		uint32_t		GetDMASize() const { return m_dmaTransferSize; }

	private:

		uint32_t	m_paramCount;
		uint32_t	m_maxParamCount;
		uint8_t*	m_buffer;
		uint8_t*	m_dmaBuffer;
		uint32_t	m_dmaBufferSize;
		uint32_t	m_dmaTransferSize;

	};

    void BuildLoadPageCommand( uint32_t* cmdBuffer, const void* ea, uint16_t imageSize, uint8_t pageIndex, bool execute );
    void BuildExecutePageCommand( uint32_t* cmdBuffer, uint32_t param0, uint32_t param1, uint8_t pageIndex );
    void BuildSetQueueAddressCommand( uint32_t* cmdBuffer, const void* queueAddress );
    void BuildSendEventCommand( uint32_t* cmdBuffer, uint32_t value );
    void ProcessCommandQueue( uint32_t threadID, uint32_t cmdCount );

}



#ifdef __cplusplus
extern "C"
{
#endif


//Some global scope helper functions for queue command building.
//In their current form, these funstions are temporary.


#ifdef __cplusplus
}
#endif

#endif
