/******************************************************************

  Module: SyDamageNumMgr.h

  Author: John Buckley

  Description:

    Damage Number Manager Class

  Copyright 2004 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __SYDAMAGENUMMGR_H__
#define	__SYDAMAGENUMMGR_H__

/*
**
**	 Includes
**
*/

#include "SyVect2I.h"
#include "SyVect2.h"
#include "SyPool.h"
#include "SyTime.h"
#include "gameobj.h"



#define SYDAMAGENUMMGR_MAXDIGITS   4
#define SYDAMAGENUMMGR_LIMIT       9999


class SyCamera;
class Titan;

/* Damage Number Blits */

class SyDamageNumBlits
 {
  public:

   SyVect2I mOffset;
   SyVect2I mSize;
   SyVect2  mUVs[2];
 };

/* Damage number */

class SyDamageNum
 {
  public:

   tGameObjectID mID;
   SyTime     mStartTime;
   SyTime     mLastUpdate;
   SyColor32F mColor;
   SyVect3    mVel;                 
   SyVect3    mLocation;            // Object-space location of damage number
   float      mRandScale;
   int32      mNumDigits;
   int32      mDigits[SYDAMAGENUMMGR_MAXDIGITS];
 };

/* Damage number manager */

class SyDamageNumMgr
 {
  public:

   /* Constructor */

   SyDamageNumMgr(Titan* pTitan);
   ~SyDamageNumMgr();

   /* Initialization */

   int Init();
   int Close();
   
   /* Render */

   int Add( tGameObjectID id, int DamageAmount, const SyColor32F& Color, const SyVect3& initialVel = SyVect3(0.0f, 0.0f, 0.0f));
   int Render( SyCamera& Camera );
       
  private:

   /* Private Methods */

   int UpdateNumber( SyDamageNum& DamageNum );
   int DrawNumber( SyCamera& Camera, SyTime Delta, SyDamageNum& DamageNum );

   /* Data Members */

   SyVect3               mGravity;
   SyDamageNumBlits      mDigitBlits[10];

   SyPool< SyDamageNum > mDamageNums;   

   int32                 mMaterialHandle;
   Titan*                mpTitan;
 };

/**/


/*
**
**	 Function Prototypes
**
*/

/**/

#endif	//	__SYDAMAGENUMMGR_H__

/* End of File */
