/******************************************************************
  
  Module:  aigoal_cast.h
  
  Author: Borut Pfeifer
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/
#ifndef AIGOAL_CAST_H
#define AIGOAL_CAST_H

//-------------------------------------------------------- Includes
#include "aigoal.h"

class cSpellMaster;

//
// cGoal_Cast - base spell casting behavior class
//
class cGoal_Cast : public cAiGoal
{
public:
  cGoal_Cast(tGameID spellID, tGameObjectID targetID);
  cGoal_Cast(tGameID spellID, const SyVect3& targetLocation);

  virtual eGoalType GetType(){return GOAL_CAST;};

  virtual void Update(float time);

protected:
  cGoal_Cast();

  virtual bool MoveToCastPosition(float speed); // true if we're in cast position
  virtual bool Cast(float time); // if we should continue casting

  tGameID mSpellID;
  cAILOSMemory mSpellTargetLOS;
};

#endif
