/******************************************************************
  
  Module:  behaviortypes.h
  
  Author: Borut Pfeifer
  
  Description: enum for the different behaviors that an NPC can have
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef BEHAVIORTYPES_H
#define BEHAVIORTYPES_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

enum NPCBehaviorTypes
{
  NPCBEH_CLASSDEFAULT = 0,
  NPCBEH_NONE,
  NPCBEH_BASIC, 
  NPCBEH_SWARM, 
  NPCBEH_FLANK, 
  NPCBEH_CHARGERETREAT, 
  NPCBEH_KAMIKAZE, 
  NPCBEH_STEALTH, 
  NPCBEH_WANDER, 
  NPCBEH_SENTINEL, 
  NPCBEH_CIRCLE, 
  NPCBEH_LINE, 
  NPCBEH_STUN, 
  NPCBEH_RUN, 
  NPCBEH_CAST, 
  NPCBEH_MAXTYPES, 
};

enum NPCFactionType
{
  NPCFACTION_CLASSDEFAULT = 0,
  NPCFACTION_MONSTER,
  NPCFACTION_NEUTRAL,
  NPCFACTION_ALLY,
  NPCFACTION_PROP,
  NPCFACTION_MAXTYPES,
};

// yick, I know, but this was the only way to avoid declaring this in multiple spots
// it's defined in behaviortypes.cpp
extern const char *NPC_BEHAVIOR_TYPE_NAMES[NPCBEH_MAXTYPES];

extern const char *NPC_FACTION_NAMES[NPCFACTION_MAXTYPES];

#endif
