/******************************************************************
  
  Module:  class.h
  
  Author: Sean Craig
  
  Description:  Code for character classes, game statistics
  which vary with the character level.

  Data is set by the designers in an Access database, exported into
  an XML file, then parsed into the cClass structure.
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef CLASS_H
#define CLASS_H

//-------------------------------------------------------- Includes
#include "nameid.h"
#include "rulepacket.h"

//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
class TiXmlNode;

class cStatistics
{
public:
  cStatistics();
  void          Parse(TiXmlNode* node);

  float         mAttackPower;
  float         mSpellPower;
  float         mPhysicalDefense;
  float         mMagicalDefense;
  float         mStrikethrough;
  float         mBlockMeter;

  float         mMovementSpeed;
  float         mCloseDistance;
  float         mMeleeRange;
  float         mAccuracy;
  float         mThrowStrength;
  float         mDropChance;
  float         mDropHealthAmount;
  float         mDropHealthWeight;
  float         mDropManaAmount;
  float         mDropManaWeight;
  float         mDropEssenceAmount;
  float         mDropEssenceWeight;
};

class cCharacterClass
{
public:
  cCharacterClass();

  cNameID      mName;
  cStatistics  mStats;

  float         mMaxHP;
  float         mMaxMana;
  float         mDamage;
  float         mElementalMultipliers[NUM_ELEMENTAL_TYPES];

  char          mNPCBehaviorType;  // selects appropriate actions/goals for NPC
  char          mNPCFaction;  // is ally/monster?

  float         mXPMultiplier;
};


class cCharacterLevel
{
public:
  cCharacterLevel();

  int           mLevel;
  cStatistics   mStats;
  int           mXPRequired;

  float         mMaxPlayerHP;
  float         mMaxPlayerMana;
  float         mMaxNPCHP;
  float         mMaxNPCMana;
  float         mPlayerDamage;
  float         mNPCDamage;
};

class cExperienceTable
{
public:
  cExperienceTable();

  int GetExperience(int deltaXP) const;

  enum Constants
  {
    MAX_LEVEL_DELTAS = 199
  };

  short mDeltaExpReward[MAX_LEVEL_DELTAS];  
};


class cDifficultySettingsTable
{
public:
  cDifficultySettingsTable();

  enum Constants
  {
    MAX_DIFFICULTY_LEVELS = 10
  };

  float mDamageMultipliers[MAX_DIFFICULTY_LEVELS];
  float mHealthMultipliers[MAX_DIFFICULTY_LEVELS];
  float mBlockMultipliers[MAX_DIFFICULTY_LEVELS];
};

//------------------------------------------- Function Declarations


cCharacterClass *ParseClass(TiXmlNode* node);
cCharacterLevel *ParseLevel(TiXmlNode* node);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
