/******************************************************************
  
  Module:  debugoverlay.h
  
  Author: Borut Pfeifer
  
  Description: Render debug info for a character's AI

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef DEBUGOVERLAY_H
#define DEBUGOVERLAY_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

//#ifdef _DEBUG
#define _DRAWDEBUGOVERLAY
//#endif

#ifdef _DRAWDEBUGOVERLAY

#include "SyColor.h"
#include "SyVect3.h"
#include "gameobj.h"

#define DEBUGOVERLAY_ENABLECHANNEL(channelName, bEnable) cDebugOverlay::Get()->EnableChannel((channelName), (bEnable))

#define DEBUGOVERLAY_DRAWLINE(objID, channelName, start, end, color) cDebugOverlay::Get()->DrawLine((objID), (channelName), (start), (end), (color))
#define DEBUGOVERLAY_DRAWBBOX(objID, channelName, min, max, color) cDebugOverlay::Get()->DrawBBox((objID), (channelName), (min), (max), (color))
#define DEBUGOVERLAY_DRAWORIENTEDBOX(objID, channelName, center, halfLength, halfWidth, height, color) cDebugOverlay::Get()->DrawOrientedBox((objID), (channelName), (center), (halfLength), (halfWidth), (height), (color))
#define DEBUGOVERLAY_DRAWSPHERE(objID, channelName, center, radius, color) cDebugOverlay::Get()->DrawSphere((objID), (channelName), (center), (radius), (color))
#define DEBUGOVERLAY_DRAWARROW(objID, channelName, start, end, color) cDebugOverlay::Get()->DrawArrow((objID), (channelName), (start), (end), (color))
#define DEBUGOVERLAY_DRAWCYLINDER(objID, channelName, center, radius, axis, color) cDebugOverlay::Get()->DrawCylinder((objID), (channelName), (center), (radius), (axis), (color))
#define DEBUGOVERLAY_DRAWWORLDTEXT(objID, channelName, loc, text, color) cDebugOverlay::Get()->DrawWorldText((objID), (channelName), (loc), (cDebugOverlay::BufferPrintf text), (color))
#define DEBUGOVERLAY_DRAWSCREENTEXT(objID, channelName, x, y, text, color) cDebugOverlay::Get()->DrawScreenText((objID), (channelName), (x), (y), (cDebugOverlay::BufferPrintf text), (color))

#else

#define DEBUGOVERLAY_ENABLECHANNEL(channelName, bEnable)

#define DEBUGOVERLAY_DRAWLINE(objID, channelName, start, end, color)
#define DEBUGOVERLAY_DRAWBBOX(objID, channelName, min, max, color)
#define DEBUGOVERLAY_DRAWORIENTEDBOX(objID, channelName, center, halfLength, halfWidth, height, color)
#define DEBUGOVERLAY_DRAWSPHERE(objID, channelName, center, radius, color)
#define DEBUGOVERLAY_DRAWARROW(objID, channelName, start, end, color)
#define DEBUGOVERLAY_DRAWCYLINDER(objID, channelName, center, radius, axis, color)
#define DEBUGOVERLAY_DRAWWORLDTEXT(objID, channelName, loc, text, color) 
#define DEBUGOVERLAY_DRAWSCREENTEXT(objID, channelName, x, y, text, color)

#endif


#ifdef _DRAWDEBUGOVERLAY

class SyRaster;
class SyCamera;
class cGameObjectRegistry;

class cDebugOverlay
{
public:
  cDebugOverlay();
  ~cDebugOverlay();

  static cDebugOverlay* Get() { return smpThis; }

  static const char* BufferPrintf(const char* text, ...);

  void DrawLine(tGameObjectID objID, const char* channelName,
                const SyVect3& start, const SyVect3& end, SyColor32F color);

  void DrawBBox(tGameObjectID objID, const char* channelName,
                const SyVect3& min, const SyVect3& max, SyColor32F color);

  void DrawOrientedBox(tGameObjectID objID, const char* channelName,
                       const SyVect3& center, const SyVect3& length, 
                       const SyVect3& width, const SyVect3& height, SyColor32F color);

  void DrawArrow(tGameObjectID objID, const char* channelName,
                 const SyVect3& start, const SyVect3& end, SyColor32F color);

  void DrawSphere(tGameObjectID objID, const char* channelName,
                  const SyVect3& center, float radius, SyColor32F color);

  void DrawCylinder(tGameObjectID objID, const char* channelName,
                    const SyVect3& center, float radius, const SyVect3& axis, SyColor32F color);

  void DrawWorldText(tGameObjectID objID, const char* channelName,
                     const SyVect3& loc, const char* text, SyColor32F color);

  void DrawScreenText(tGameObjectID objID, const char* channelName,
                      int screenX, int screenY, const char* text, SyColor32F color);

  bool IsEnabled();
  void Enable(bool bEnable);

  void EnableChannel(const char* channelName, bool bEnable);
  bool IsChannelEnabled(const char* channelName);

  void SelectAllObjects();
  void SelectNextObject(cGameObjectRegistry* pRegistry, SyCamera* pCam);
  void SelectPrevObject(cGameObjectRegistry* pRegistry, SyCamera* pCam);
  void Render(SyRaster* pRasterDev, SyCamera* pCam);


  static const SyColor32F RED;
  static const SyColor32F GREEN;
  static const SyColor32F BLUE;
  static const SyColor32F CYAN;
  static const SyColor32F MAGENTA;
  static const SyColor32F YELLOW;
  static const SyColor32F ORANGE;
  static const SyColor32F PURPLE;
  static const SyColor32F GRAY;
  static const SyColor32F BROWN;
  static const SyColor32F WHITE;
  static const SyColor32F BLACK;


private:
  static cDebugOverlay* smpThis;

  class Implementation;

  Implementation* mpImp;
};

#endif

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
