/******************************************************************
  
  Module:  inventory.h
  
  Author: Sean Craig
  
  Description: Classes to hold items.  The player's backpack, a 
  chest, etc.
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef INVENTORY_H
#define INVENTORY_H

//-------------------------------------------------------- Includes
#include <stdio.h>
#include "SyPropObject.h"
#include "item.h"

//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class cGameObject;
class cRulePacket;

class cInventory : public SyPropObject
{
public:
  cInventory();
  virtual ~cInventory(){};

  /* Property Class Support */
  static int           InitPropClass();
  static SyPropObject* Creator();
  static const int     mCLASSID           =  0xFFFF3001;

  // public interface
  virtual void Clear(){};
  virtual void Init(){};
  virtual void Exit(){};
  void Update(float time){};

  virtual cItem *         Add(tGameID itemID,int quantity=1){return NULL;};
  void SetOwner(cGameObject *);
  virtual void ProcessRulePacket(cRulePacket *packet){};

protected:
                                 
  cGameObject       *mOwner;
};

class cInventoryNone : public cInventory
{
public:
  cInventoryNone();
  /* Property Class Support */
  static int           InitPropClass();
  static SyPropObject* Creator();
  static const int    mCLASSID       =  0xFFFF3002;

  // public interface

};

class cInventoryContainer : public cInventory
{
public:
  cInventoryContainer();
  virtual ~cInventoryContainer();
  /* Property Class Support */
  static int           InitPropClass();
  static SyPropObject* Creator();
  static const int    mCLASSID  =  0xFFFF3003;

  // public interface
  virtual void         Clear();
  virtual void         Init();
  virtual bool         Drop(cItem *item);
          bool         DropAll(); // when a monster is killed, when a container is shattered
  virtual bool         Remove(cItem *item);
  cItem *              Add(cItem *item);
  virtual cItem *      Add(tGameID itemID,int quantity=1);
  bool                 PickUp(cGameObject *obj); // object in world

  int                  GetNumItems();
  cItem *              GetItem(int index);

protected:
  SyVector<cItem *>      mItems;

};

class cInventoryCharacter: public cInventoryContainer
{
public:
  cInventoryCharacter();
  /* Property Class Support */
  static int           InitPropClass();
  static SyPropObject* Creator();
  static const int     mCLASSID  =  0xFFFF3004;

  // public interface

  virtual bool         Drop(cItem *item);
  cItem*               GetEquippedItem(eEquipSlot slot);
  bool                 Equip(cItem *item, eEquipSlot slot);
  void                 Unequip(eEquipSlot slot);
  virtual void         ProcessRulePacket(cRulePacket *packet);
};



//------------------------------------------- Function Declarations
void RegPropClasses_Inventory();
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
