/******************************************************************
  
  Module:  motioncontroller_service.h
  
  Author: Sean Craig
  
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef MOTIONCONTROLLER_SERVICE_H
#define MOTIONCONTROLLER_SERVICE_H

//-------------------------------------------------------- Includes
#include "service.h"
#include "SyCurve.h"
//-------------------------------------------------------- Typedefs

//---------------------------------------------- Class Declarations
class cGameObject;

namespace MotionControl
{
  enum Option
  {
    MOVE_ONCE,
    MOVE_LOOP,
    MOVE_PINGPONG,
  };
}

class cMotionController_Entry
{
public:
  tGameID       mObject;
  float         mTime;

  SyCurve       mCurveX;
  SyCurve       mCurveY;
  SyCurve       mCurveZ;
  SyCurve       mCurveHeading;

  MotionControl::Option mMoveOption;
  float         mSpeed;

  bool          mPaused;

  SyEmbeddedListLink<cMotionController_Entry> mListLink;  
};

class cMotionController_Service : public cService 
{
public:
  cMotionController_Service(){}
  virtual ~cMotionController_Service();

  virtual void    Reset(); // once on level change
  virtual void    Perform( float time );  // performs the service

  virtual tGameID GetID() const {return mNameID.GetID();}

          void    Add( const cGameObject& object, const cGameObject& marker, float speed, MotionControl::Option moveOption );
          bool    Stop( const cGameObject& );
          bool    Pause( const cGameObject& );
          bool    Resume( const cGameObject& );

  static cNameID  mNameID;

protected:

  bool    _Move(float time,cMotionController_Entry *entry);
  SyEmbeddedList<cMotionController_Entry,&cMotionController_Entry::mListLink> mEntries;   
};

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
