/******************************************************************
  
  Module:  rule_inventory.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "rule_inventory.h"
#include "item.h"
//---------------------------------------------- Class Declarations

class cInventoryRule_Base: public cInventoryRule
{
public:

  virtual void    CalcDamageInitial(cDamagePacket *packet);

  virtual void    CalcHealthMax(cCalcPacket *packet);
  virtual void    CalcManaMax(cCalcPacket *packet);

  virtual void    CalcOffense(cDamagePacket *packet);
  virtual void    CalcDefense(cDamagePacket *packet);
  virtual void    CalcSpellPower(cCalcPacket *packet);
};
//----------------------------------------- Functions Declarations
//------------------------------------ Member Functions Definitions

//---------------------------------------- InventoryRuleContainer

cInventoryRuleContainer::cInventoryRuleContainer()
{
  mpBase = new cInventoryRule_Base();

  // add enhancement effects
}

cInventoryRuleContainer::~cInventoryRuleContainer()
{
  delete mpBase;


  int curIndex;
  for (curIndex = mEnhancementEffects.Begin();
       curIndex != mEnhancementEffects.End();
       curIndex = mEnhancementEffects.Next(curIndex))
  {
    delete mEnhancementEffects(curIndex);
  }

  mEnhancementEffects.Clear();
}

void           
cInventoryRuleContainer::SetTitan(Titan *titan)
{ 
  mpBase->SetTitan(titan);
};


void 
cInventoryRuleContainer::ProcessPacket(cItem *item,cRulePacket *packet)
{
  mpBase->SetItem(item);
  mpBase->ProcessPacket(packet);

}


//---------------------------------------- InventoryRule_Base

void    
cInventoryRule_Base::CalcDefense(cDamagePacket *packet)
{
  switch (packet->GetDamageType())
  {
    case DT_PHYSICAL:
      packet->AddTotal(mpItem->GetMaster()->mPhysicalDefense,"Item",mpItem->GetMaster()->mID.GetName());
      break;
    case DT_MAGICAL:
      packet->AddTotal(mpItem->GetMaster()->mMagicalDefense,"Item",mpItem->GetMaster()->mID.GetName());
      break;
    case DT_NONE:
    default:
      SyAssertf(0,"Bad damage type?");
      break;;
  }
}

void    
cInventoryRule_Base::CalcDamageInitial(cDamagePacket *packet)
{
}

void    
cInventoryRule_Base::CalcHealthMax(cCalcPacket *packet)
{
  packet->AddTotal(mpItem->GetMaster()->mMaxHP,"Item",mpItem->GetMaster()->mID.GetName());
};

void    
cInventoryRule_Base::CalcManaMax(cCalcPacket *packet)
{
  packet->AddTotal(mpItem->GetMaster()->mMaxMana,"Item",mpItem->GetMaster()->mID.GetName());
};

void    
cInventoryRule_Base::CalcSpellPower(cCalcPacket *packet)
{
  packet->AddTotal(mpItem->GetMaster()->mSpellPower,"Item",mpItem->GetMaster()->mID.GetName());
};

void    
cInventoryRule_Base::CalcOffense(cDamagePacket *packet)
{
  if (packet->mbMagic)
  {
    packet->AddTotal(mpItem->GetMaster()->mSpellPower,"Item",mpItem->GetMaster()->mID.GetName());
  }
  else
  {
    packet->AddTotal(mpItem->GetMaster()->mAttackPower,"Item",mpItem->GetMaster()->mID.GetName());
  }
  
}

// EOF
