/******************************************************************
  
  Module:  script_func.h
  
  Author: Sean Craig
  

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef SCRIPT_FUNC_H
#define SCRIPT_FUNC_H

//-------------------------------------------------------- Includes
#ifdef __CELLOS_LV2__
    #define HAVE_STDINT_H
#endif

#define HAVE_I64

#include <sys/types.h>
#include "pawn/amx/amx.h"

//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
class Titan;

class cNetScriptFuncPacket;
//------------------------------------------- Function Declarations

void scriptFuncs_Init(Titan *titan);

void script_RegisterNatives(AMX *amx); // registers native functions with a virtual machine

void scriptFuncs_RegisterTuningVars();

void scriptFuncs_ProcessPacket(cNetScriptFuncPacket *packet);

bool scriptFuncs_IsRemote(AMX *amx);

bool scriptFuncs_IsTest(AMX *amx);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
