/******************************************************************
  
  Module:  service.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "service.h"
//---------------------------------------------- Class Declarations

//---------------------------------------------- cServiceScheduler

cServiceScheduler::cServiceScheduler()
{
};

cServiceScheduler::~cServiceScheduler()
{
  mServices.DeleteAll();
};

void 
cServiceScheduler::Init(Titan *titan)
{
  mpTitan = titan;
};


void 
cServiceScheduler::Reset()
{
  cService *cur = mServices.First();

  while (cur != NULL)
  {
    cur->Reset();
    cur = mServices.Next(cur);
  }
};


void 
cServiceScheduler::Perform(float time)
{
  cService *cur = mServices.First();

  while (cur != NULL)
  {
    cur->Perform(time);
    cur = mServices.Next(cur);
  }
};


void 
cServiceScheduler::AddService(cService *service)
{
  mServices.InsertTail(service,service->GetID());
  service->Init(mpTitan);
};


cService *
cServiceScheduler::Fetch(tGameID id)
{
  return mServices.FindFirst(id);
};

//----------------------------------------- Functions Declarations

//------------------------------------ Member Functions Definitions


// EOF
