/******************************************************************
  
  Module:  surfacetype.h
  
  Author: Borut Pfeifer
  
  Description: enum for the different surface types that the player
               can hit in game
  
  Copyright 2006 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef SURFACETYPE_H
#define SURFACETYPE_H

#include "nameid.h"
#include "SyCollSurfType.h"
#include "SyString.h"
#include "SyMap.h"

class cGameObject;
class Titan;
class SyCollRay;
class SySceneFilter;

enum GameSurfaceType
{
  GAME_SURFACE_DEFAULT      = SYCOLLSURFTYPE_NONE,
  GAME_SURFACE_EARTH        = SYCOLLSURFTYPE_EARTH,
  GAME_SURFACE_WOOD         = SYCOLLSURFTYPE_WOOD,
  GAME_SURFACE_ROCK         = SYCOLLSURFTYPE_ROCK,
  GAME_SURFACE_METAL        = SYCOLLSURFTYPE_METAL,
  GAME_SURFACE_SAND         = SYCOLLSURFTYPE_SAND,
  GAME_SURFACE_SNOW         = SYCOLLSURFTYPE_SNOW,
  GAME_SURFACE_ICE          = SYCOLLSURFTYPE_ICE,
  GAME_SURFACE_DUNGEON_WATER,
  GAME_SURFACE_SEWER_WATER,
  GAME_SURFACE_POND_WATER,
  GAME_SURFACE_MUD,
  GAME_SURFACE_LAVA,
  GAME_SURFACE_MAX_TYPES, 
};


class cImpactFXSet
{
  public:
    cImpactFXSet();

    tGameID GetEffectForWaterType(int water) const;
    tGameID GetEffectForCollisionSurfaceType(SyCollSurfType collision) const;

    void PlayImpact(cGameObject* pObj, bool bAttach = false) const;
    void PlayImpact(Titan* pTitan, SyCollRay& ray, SySceneFilter& filter, int waterType) const;

    static int32 GetCharacterFXHandle(const char* effectName, cGameObject* pObj);

    cNameID mID;
    SyString mCharacterFXName;
    SyString mCharacterBlockFXName;
    tGameID mPropFXID;
    tGameID mDebrisFXID;
    tGameID mSurfaceFXIDs[GAME_SURFACE_MAX_TYPES];
};

enum CharacterSoundSurfaceType
{
  CHARACTER_SOUND_SURFACE_FLESH,
  CHARACTER_SOUND_SURFACE_LEATHER,
  CHARACTER_SOUND_SURFACE_METAL,
  CHARACTER_SOUND_SURFACE_STONE,
  CHARACTER_SOUND_SURFACE_MAGIC,
  CHARACTER_SOUND_SURFACE_MAX_TYPES,
};

class cImpactSoundSet
{
  public:
    cImpactSoundSet();
    ~cImpactSoundSet();

    void PlayHitSound(cGameObject* pObj) const;
    void PlayHitSound(Titan* pTitan, SyCollRay& ray, SySceneFilter& filter, int water) const;

    static const int MAX_PERMUTATIONS = 3;

    cNameID mID;
    SyMap<tGameID, tGameID> mSounds;
};

#endif
