/******************************************************************
  
  Module:  tuning.h
  
  Author: Sean Craig
  
  Description:  Tuning variables

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef TUNING_H
#define TUNING_H

//-------------------------------------------------------- Includes
#include "SyVector.h"
#include "nameid.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
class cTuningVar;

class cTuningSys
{
public:
  cTuningSys(){};
  virtual ~cTuningSys();
  void Init(); // call before values are added;
  bool LoadValues(const char *filename);
  bool AddFloat(float *var, const char *name);
  bool AddInt(int *var, const char *name);
  bool AddAngle(float *var, const char *name);
  bool AddGameID(tGameID *var, const char *name);

protected:
  SyVector<cTuningVar *> mVars;
};
//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
extern cTuningSys gTuningSys; // only one set of tuning variables for all games
//------------------------------------------------ Inline Functions

#endif
