#include "SyScene.h"
#include "tinyxml.h"
#include "gameerror.h"

void WaterInit_LoadFluidProfilesXMLArt()
{
  SyWaterTile::SyWaterProfile * waterProfiles = SyWaterTile::GetWaterProfiles();

  // load up xml file for experience...
  TiXmlDocument doc( "game_assets/art/data/fluid_profiles.xml" );
  bool loadOkay = doc.LoadFile();

  if ( !loadOkay )
  {
    GAME_ASSERT(ERROR_DESIGN, false, "Could not load game_assets/art/data/fluid_profiles.xml");
    return;
  }

  TiXmlNode* node = 0;
  TiXmlNode* data_node = 0;

  node = doc.FirstChild( "FluidProfiles" );
  SyAssert(node);

  // get the fluids
  int ID = 0;
  node = node->FirstChild( "Fluid" );
  SyAssert(node);
  while (node != NULL)
  {
    data_node = node->FirstChild("ID");
    GAME_ASSERT(ERROR_DESIGN, data_node && data_node->FirstChild() && data_node->FirstChild()->Value(), "Empty ID attribute");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      ID = atoi(data_node->FirstChild()->Value());
    }
    if (ID < 0 || ID > 31 )
    {
      GAME_ASSERT(ERROR_ART, 0, "check fluid.xml - ID must be from 0 and 31" );
      return;
    }

    waterProfiles[ID].InitArt1();

    data_node = node->FirstChild("FromColor");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      int r,g,b,a;
      sscanf( data_node->FirstChild()->Value(), "%d,%d,%d,%d", &r, &g, &b, &a );
      SyColor32 color( r, g, b, a );
      waterProfiles[ID].FromColor = color;
    }

    data_node = node->FirstChild("ToColor");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      int r,g,b,a;
      sscanf( data_node->FirstChild()->Value(), "%d,%d,%d,%d", &r, &g, &b, &a );
      SyColor32 color( r, g, b, a );
      waterProfiles[ID].ToColor = color;
    }

    data_node = node->FirstChild("Viscosity");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      waterProfiles[ID].Viscosity = (float)atof(data_node->FirstChild()->Value());
    }

    data_node = node->FirstChild("InitValue");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      waterProfiles[ID].InitValue = (float)atof(data_node->FirstChild()->Value());
    }

    data_node = node->FirstChild("Name");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      strncpy( waterProfiles[ID].Name, data_node->FirstChild()->Value(), 44 );
      waterProfiles[ID].Name[43] = 0;
    }

    data_node = node->FirstChild("FluidShaderIndex");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      int i = atoi(data_node->FirstChild()->Value());
      if ( i >=0 && i <= 7 )
      {
        waterProfiles[ID].FluidShaderIndex = i;
      }
      else
      {
        waterProfiles[ID].FluidShaderIndex = 0;
      }
    }

    node = node->NextSibling();
  }
}

void WaterInit_ReloadShaders(SyRaster& raster)
{
  SyWaterSystem::ReloadShaders(raster);
}


void WaterInit_LoadFluidProfilesXMLDesign()
{
  SyWaterTile::SyWaterProfile * waterProfiles = SyWaterTile::GetWaterProfiles();

  // load up xml file for experience...
  TiXmlDocument doc( "game_assets/design/data/fluid_profiles.xml" );
  bool loadOkay = doc.LoadFile();

  if ( !loadOkay )
  {
    GAME_ASSERT(ERROR_DESIGN, false, "Could not load game_assets/design/data/fluid_profiles.xml");
    return;
  }

  TiXmlNode* node = 0;
  TiXmlNode* data_node = 0;

  node = doc.FirstChild( "FluidProfiles" );
  SyAssert(node);

  // get the fluids
  int ID = 0;
  node = node->FirstChild( "Fluid" );
  SyAssert(node);
  while (node != NULL)
  {
    data_node = node->FirstChild("ID");
    GAME_ASSERT(ERROR_DESIGN, data_node && data_node->FirstChild() && data_node->FirstChild()->Value(), "Empty ID attribute");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      ID = atoi(data_node->FirstChild()->Value());
    }
    if (ID < 0 || ID > 31 )
    {
      GAME_ASSERT(ERROR_ART, 0, "check fluid.xml - ID must be from 0 and 31" );
      return;
    }

    waterProfiles[ID].InitDesign2();

    data_node = node->FirstChild("SpellName");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      if (data_node->FirstChild()->Value()[0]!=0)
      {
        waterProfiles[ID].SpellName = SyHashResourceID( data_node->FirstChild()->Value() );
      }
    }

    data_node = node->FirstChild("ImpactEffectName");
    if (data_node && data_node->FirstChild() && data_node->FirstChild()->Value())
    {
      if (data_node->FirstChild()->Value()[0]!=0)
      {
        waterProfiles[ID].ImpactEffectName = SyHashResourceID( data_node->FirstChild()->Value() );
      }
    }

    node = node->NextSibling();
  }
}


void WaterInit_LoadFluidProfilesXML()
{
  WaterInit_LoadFluidProfilesXMLArt();
  WaterInit_LoadFluidProfilesXMLDesign();
}

