#ifndef HTTPFILEDOWNLOAD_H
#define HTTPFILEDOWNLOAD_H

#include "SyTypes.h"

class HttpFileDownloadInternal;

class HttpFileDownload
{
    public:
        HttpFileDownload();
        ~HttpFileDownload();

            // starts a download, 0 = success, -1 = failure
        int DownloadStart(const char *url, const char *destFile);

            // checks status, 0 = in-progress, -1 = failure, 1 = finished
            // note: must be called frequently until download is complete
        int DownloadStatus(uint64 *pTotalReceived, uint64 *pTotalSize);

    private:
        HttpFileDownloadInternal *m_data;
};


#endif  // HTTPFILEDOWNLOAD_H

