/////////////////////////////////////////////////////////////////////////////
// Name:        PawnDebug.h
// Purpose:     
// Author:      Vince Harron
// Modified by: 
// Created:     10/04/05 12:04:51
// RCS-ID:      
// Copyright:   2005 Sony Online Entertainment
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _PAWNDEBUG_H_
#define _PAWNDEBUG_H_

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma interface "PawnDebug.cpp"
#endif

/*!
 * Includes
 */

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_DIALOG 10038
#define SYMBOL_PAWNDEBUG_STYLE wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX
#define SYMBOL_PAWNDEBUG_TITLE _("Pawn Debug")
#define SYMBOL_PAWNDEBUG_IDNAME ID_DIALOG
#define SYMBOL_PAWNDEBUG_SIZE wxSize(400, 300)
#define SYMBOL_PAWNDEBUG_POSITION wxDefaultPosition
#define ID_VARIABLES 10043
#define ID_TEXTCTRL 10042
#define ID_BUTTON_RUN 10039
#define ID_BUTTON_STEP 10040
#define ID_BUTTON_DEBUG_OFF 10041
////@end control identifiers

/*!
 * Compatibility
 */

#ifndef wxCLOSE_BOX
#define wxCLOSE_BOX 0x1000
#endif
#ifndef wxFIXED_MINSIZE
#define wxFIXED_MINSIZE 0
#endif

/*!
 * PawnDebug class declaration
 */

class PawnDebug: public wxDialog
{    
    DECLARE_DYNAMIC_CLASS( PawnDebug )
    DECLARE_EVENT_TABLE()

public:
    typedef enum
    {
      RESULT_RUN,
      RESULT_STEP,
      RESULT_STOP_DEBUGGING
    }eResult;
    /// Constructors
    PawnDebug( );
    PawnDebug( wxWindow* parent, wxWindowID id = SYMBOL_PAWNDEBUG_IDNAME, const wxString& caption = SYMBOL_PAWNDEBUG_TITLE, const wxPoint& pos = SYMBOL_PAWNDEBUG_POSITION, const wxSize& size = SYMBOL_PAWNDEBUG_SIZE, long style = SYMBOL_PAWNDEBUG_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_PAWNDEBUG_IDNAME, const wxString& caption = SYMBOL_PAWNDEBUG_TITLE, const wxPoint& pos = SYMBOL_PAWNDEBUG_POSITION, const wxSize& size = SYMBOL_PAWNDEBUG_SIZE, long style = SYMBOL_PAWNDEBUG_STYLE );

    /// Creates the controls and sizers
    void CreateControls();

////@begin PawnDebug event handler declarations

    /// wxEVT_CLOSE_WINDOW event handler for ID_DIALOG
    void OnCloseWindow( wxCloseEvent& event );

    /// wxEVT_CHAR event handler for ID_DIALOG
    void OnChar( wxKeyEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_RUN
    void OnButtonRunClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_STEP
    void OnButtonStepClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_DEBUG_OFF
    void OnButtonDebugOffClick( wxCommandEvent& event );

////@end PawnDebug event handler declarations

////@begin PawnDebug member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end PawnDebug member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

    void  SetSource(const wxString &source,int linenum);

    void  SetVariables(const wxString &source);
    eResult GetResult(){return mResult;}

////@begin PawnDebug member variables
    wxTextCtrl* mpVariables;
    wxTextCtrl* mpSourceView;
////@end PawnDebug member variables
    eResult     mResult;
    
};

#endif
    // _PAWNDEBUG_H_
