#ifndef __RAWCONTROLLER_H__
#define __RAWCONTROLLER_H__

class RawController
{
public:
  // Initializes an instance of the RawController class
  RawController(void);

  // Gets the current value for the specified axis.
  int GetAxis( int axis );

  // Gets the number of axes on this joystick.
  int GetAxisCount();

  // Gets the minimum value for the specified axis.
  int GetAxisMin( int axis );

  // Gets the maximum value for the specified axis.
  int GetAxisMax( int axis );

  // Gets the current value for the specified button.
  int GetButton( int button );

  // Gets the number of axes on this joystick.
  int GetButtonCount();

  // Gets a bitmask that represents the state of all buttons on the joystick.
  // bit 0 represents button 0, bit 1 represents button 1, etc.
  int GetButtonStates();

  // Returns a value that indicates whether the specified joystick is connected
  // and functioning.
  bool GetConnected();

  // Sets the current value for the specified axis.
  void SetAxis( int axis, int value );

  // Sets the current value for the specified button.
  void SetButton( int button, int value );

  // Sets a value that indicates whether the specified joystick is connected
  // and functioning.
  void SetConnected( bool value );

  // Converts a POV value to an array of d-pad button states
  // pov - angle of the pov in hundreths of degrees, -1 for centered
  // buttons - the array of buttons to set u,r,d,l
  static void POVtoDPAD( int pov, int buttons[4] );

  static const int AXIS_MAX   = 4;
  static const int BUTTON_MAX = 16;

private:

  bool mConnected;
  int  mAxis[AXIS_MAX];
  int  mButton[BUTTON_MAX];
};


#endif // __RAWCONTROLLER_H__


