/********************************************************************

  Module: TiActivateWindow

  Author: Carlo Ordonez

  Description:

    Displays message from activated game object

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiActivateWindow.h"
#include "TiUIControl.h"
#include "TiUI.h"
#include "SyStr.h"
#include "TiFont.h"

//***********************************************************************
// Constructor/Destructor
//***********************************************************************

TiActivateWindow::TiActivateWindow( TiWindow* pParent )
: TiWindow( pParent )
{
  mPlayerCount = 1;
  for( int32 i = 0; i < CONTROL_MAX; i++ )
  {
    mText[i].Init( "" );
    mpCtrl[i] = SyNew TiUIControl();
  }
  m_bdPrompt.Initialize("PromptBox");
}

TiActivateWindow::~TiActivateWindow()
{
  for( int32 i = 0; i < CONTROL_MAX; i++  )
  {
    delete mpCtrl[i];
  }
}

//***********************************************************************
// SetPlayerText
//***********************************************************************

void TiActivateWindow::SetPlayerText( int32 Player, const char8* pText )
{
  int index = Player +1;
  SyAssert( index >= 0 && index < CONTROL_MAX );
  TiUIControl* pCtrl = mpCtrl[index];
  SyString& text = mText[index];

  if( pText == NULL || SyStr::strlen( pText ) == 0 )
  {
    pCtrl->Close();
  }
  else if( text.Compare( pText ) != 0 )
  {
    // text has changed
    bool instant = text.Length() > 0;
    text.Init( pText );

    if( mVisible )
    {
      pCtrl->Close( true );
      pCtrl->Open( instant );   
    }
  }
  else if (pCtrl->IsClosed())
  {
    pCtrl->Open(false);
  }
}
//***********************************************************************
// SetSubtitleText
//***********************************************************************

void TiActivateWindow::SetSubtitleText(const char8* pText )
{
  SetPlayerText(-1,pText);
};

//***********************************************************************
// Draw
//***********************************************************************

void TiActivateWindow::DrawSelf()
{
  int32 w, h;
  TiUI::Instance()->GetDisplaySize( &w, &h );

  if( w == 0 ) { return; }

  // update subtitle, if any
  TiUIControl* pCtrl = mpCtrl[SUBTITLE_INDEX];
  SyString& text = mText[SUBTITLE_INDEX];

  if( pCtrl->IsClosed() && !pCtrl->IsOpening() )
  {
    text.Init( "" );
  }

  if (text.Length() > 0)
  {
    // Jon's stuff starts here
    TiRect rectText;
    TiRect rectBox;

    TiFont font(TiUI::Instance()->GetFontHandle("Default"));
    int32 nWidth = SY_MIN(w - 20, font.GetTextWidth(text.AsChar()));
    rectText.left = (w - nWidth) / 2;
    rectText.right = rectText.left + nWidth;
    rectText.top = h - 60;
    rectText.bottom = rectText.top + 44;
    rectBox = rectText;
    rectBox.AdjustSize(20, 0);
    m_bdPrompt.Draw(rectBox);
    font.Draw(text.AsChar(), rectText, c_crWhite, TI_TF_VCENTER | TI_TF_HALIGN_CENTER | TI_TF_SHADOW);
    pCtrl->UpdateFade();
    return;

    int32 spacing = w /2;
    int32 widthMax = w - 20;

    SyVect2I center;
    center.X = spacing;
    center.Y = h - 100;

    int32 width = SY_MIN( widthMax, pCtrl->GetTextWidth(text.AsChar()) + 40 );
    int32 rows = pCtrl->CountLines( text.AsChar(), width );

    pCtrl->Init( center, width, rows, TiUIControl::kBlack );
    pCtrl->Draw();
    pCtrl->DrawTextBox( text, 20, 0, width, rows, TiUIControl::kNormal, TI_TF_SHADOW );
    return;
  }

//  int32 spacing = w / (mPlayerCount==1 ? 2 : 4);
  int32 widthMax = (w / mPlayerCount) - 20;

  for( int32 i = 1; i < mPlayerCount+1; i++ )
  {
    pCtrl = mpCtrl[i];
    text = mText[i];

    // update text
    if( pCtrl->IsClosed() && !pCtrl->IsOpening() )
    {
      text.Init( "" );
    }

    // display
    if( text.Length() > 0 )
    {
      TiRect rectText;
      TiRect rectBox;

      TiFont font(TiUI::Instance()->GetFontHandle("Default"));
      int32 nWidth = SY_MIN(widthMax, font.GetTextWidth(text.AsChar()));
      int32 nCenter = w / 2;
      if(mPlayerCount == 2)
      {
        if(i == 0)
        {
          nCenter = w / 4;
        }
        else
        {
          nCenter = (w * 3) / 4;
        }
      }
      rectText.left = nCenter - nWidth / 2;
      rectText.right = rectText.left + nWidth;
      rectText.top = h - 60;
      rectText.bottom = rectText.top + 44;
      rectBox = rectText;
      rectBox.AdjustSize(20, 0);
      m_bdPrompt.Draw(rectBox);
      font.Draw(text.AsChar(), rectText, c_crWhite, TI_TF_VCENTER | TI_TF_HALIGN_CENTER | TI_TF_SHADOW);
      pCtrl->UpdateFade();


#ifdef __OLDSHITTYSHIT
      SyVect2I center;
      center.X = spacing * (2*(i-1)+1);
      center.Y = h - 100;

      int32 width = SY_MIN( widthMax, pCtrl->GetTextWidth(text.AsChar()) + 40 );
      int32 rows = pCtrl->CountLines( text.AsChar(), width );

      pCtrl->Init( center, width, rows, TiUIControl::kBlack );
      pCtrl->Draw();
      pCtrl->DrawTextBox( text, 20, 0, width, rows, TiUIControl::kNormal, TI_TF_SHADOW );
#endif
    }
  }
}

//***********************************************************************
// IsVisible
//***********************************************************************

bool TiActivateWindow::IsVisible() const
{
  for( int32 i = 0; i < mPlayerCount+1; i++ )
  {
    TiUIControl* pCtrl = mpCtrl[i];
    if( mVisible || pCtrl->IsOpen() || pCtrl->IsOpening() || pCtrl->IsClosing() )
    {
      return( true );
    }
  }
  return( false );
}

//***********************************************************************
// Show
//***********************************************************************

void TiActivateWindow::Show( bool Visible )
{
  mVisible = Visible;
  for( int32 i = 0; i < mPlayerCount+1; i++ )
  {
    TiUIControl* pCtrl = mpCtrl[i];
    if( Visible )
    {
      pCtrl->Open();
    }
    else
    {
      pCtrl->Close( true );
    }
  }
}

