/********************************************************************

  Module: TiActivateWindow

  Author: Carlo Ordonez

  Description:

    Displays message from activated game object

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiActivateWindow_h_
#define _TiActivateWindow_h_

#include "TiWindow.h"
#include "SyString.h"
#include "TiBoxDraw.h"

class TiUIControl;
class TiActivateWindow : public TiWindow
{
public:
  TiActivateWindow( TiWindow* pParent );
  ~TiActivateWindow();

  void              SetPlayerCount( int32 Count ) { mPlayerCount = Count; }
  void              SetPlayerText( int32 Player, const char8* pText );
  void              SetSubtitleText(const char8* pText );

  // overrides
  virtual void      DrawSelf();
  virtual bool      IsVisible() const;
  virtual void      Show( bool Visible );

private:

  static const int32 PLAYER_MAX = 2; // local players
  static const int32 CONTROL_MAX = PLAYER_MAX+1; // local players
  static const int32 SUBTITLE_INDEX = 0;

  TiUIControl*      mpCtrl[CONTROL_MAX];
  SyString          mText[CONTROL_MAX];
  int32             mPlayerCount;
  TiBoxDraw         m_bdPrompt;
};

#endif

