/********************************************************************

Module: TiApp

Author: Vince Harron

Description:

Application base class

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiApp_h_
#define _TiApp_h_

class TiWindow;
class TiTopLevelWindow;
class TiDialog;
class TiEventLoop;

#include <list>

class TiApp
{
public:
  TiApp(void);
  virtual ~TiApp(void);

  virtual void RunMainLoop();

  virtual void ExitMainLoop();

  // can be overriden to perform application-specific processing
  virtual void OnFrame();

  TiWindow* GetFocus();
  bool SetFocus( TiWindow* );

  void TopLevelAdd( TiTopLevelWindow* pTopLevel );
  void TopLevelRemove( TiTopLevelWindow* pTopLevel );

  void ModalStackPush( TiDialog* pModalDialog );
  void ModalStackPop();
private:
  TiWindow*                    mpFocus;
  TiEventLoop*                 mpMainLoop;
  std::list<TiDialog*>         mModalStack;
  std::list<TiTopLevelWindow*> mTopLevelWindows;
};

#endif // _TiApp_h_
