/********************************************************************

  Module: TiAppearanceWindow

  Author: Carlo Ordonez

  Description:

    Panel for changing your appearance

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiAppearanceWindow.h"

IMPLEMENT_CLASS( TiAppearanceWindow, TiWindow )

BEGIN_EVENT_TABLE( TiAppearanceWindow, TiWindow )
EVT_KEY_DOWN( TiAppearanceWindow::OnKeyDown )
EVT_SIZE( TiAppearanceWindow::OnSize )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiAppearanceWindow::TiAppearanceWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  mSelection = 0;

  wxBoxSizer* pSizer = new wxBoxSizer( wxVERTICAL );
  SetSizer( pSizer );

  mpTitle = new wxStaticText( this, wxID_STATIC, Name );
  pSizer->Add( mpTitle, 1, wxGROW|wxALL, 5 );
}

//***********************************************************************
// Destructor
//***********************************************************************

TiAppearanceWindow::~TiAppearanceWindow()
{
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiAppearanceWindow::OnKeyDown( wxKeyEvent& event )
{
  GetParent()->ProcessEvent( event );
}

//***********************************************************************
// OnSize
//***********************************************************************

void TiAppearanceWindow::OnSize( wxSizeEvent& event )
{
  int w, h;
  wxDisplaySize( &w, &h );
  w = (int)( float(w) * .35f );

  wxSize s = mpTitle->GetMinSize();
  s.SetWidth( w );
  mpTitle->SetMinSize( s );

  GetSizer()->SetSizeHints( this );
  Layout();
}

