/********************************************************************

  Module: TiAttributeWindow

  Author: Carlo Ordonez

  Description:

    Panel for allocating attribute points

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiAttributeWindow.h"

IMPLEMENT_CLASS( TiAttributeWindow, TiWindow )

BEGIN_EVENT_TABLE( TiAttributeWindow, TiWindow )
EVT_KEY_DOWN( TiAttributeWindow::OnKeyDown )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiAttributeWindow::TiAttributeWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  wxBoxSizer* pSizer = new wxBoxSizer( wxVERTICAL );
  SetSizer( pSizer );

  wxStaticText* pText = new wxStaticText( this, wxID_STATIC, Name );
  pSizer->Add( pText, 1, wxGROW|wxALL, 5 );
}

//***********************************************************************
// Destructor
//***********************************************************************

TiAttributeWindow::~TiAttributeWindow()
{
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiAttributeWindow::OnKeyDown( wxKeyEvent& event )
{
  GetParent()->ProcessEvent( event );
}

