/******************************************************************

  Module: TiBoxDraw.h

  Author: Jon Wiesman

  Description:

    2D box drawing class

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __TiBoxDraw_h__
#define __TiBoxDraw_h__

#include "TiSprite.h"
#include "SyColor.h"

enum EBoxDrawPiece
{
    BDP_TL,
    BDP_TOP,
    BDP_TR,
    BDP_RIGHT,
    BDP_BR,
    BDP_BOTTOM,
    BDP_BL,
    BDP_LEFT,
    BDP_TILE,

    BDP_MAX,
};


class TiBoxDraw
{
  TiSprite        m_spr[BDP_MAX];
  TiSize          m_sizes[BDP_MAX];
  int32           m_nInternalOffsetLeft;
  int32           m_nInternalOffsetTop;
  int32           m_nInternalOffsetRight;
  int32           m_nInternalOffsetBottom;

  TiRect          GetPieceRect(EBoxDrawPiece ePiece, TiRect rectBox) const;
  bool            CanStretchPiece(EBoxDrawPiece ePiece) const 
  {   
    return (ePiece == BDP_TOP) || (ePiece == BDP_RIGHT) || (ePiece == BDP_BOTTOM) || (ePiece == BDP_LEFT) || (ePiece == BDP_TILE);
  }

public:
  TiBoxDraw();

  void    Initialize(const char8 *pszBase);
  TiRect  GetInternalRect(TiRect rectBox) const;
  void    SetInternalOffsets(int nLeft, int nTop, int nRight, int nBottom) 
  {
    m_nInternalOffsetLeft = nLeft;
    m_nInternalOffsetTop = nTop;
    m_nInternalOffsetRight = nRight;
    m_nInternalOffsetBottom = nBottom;
  }

  void    Draw(TiRect rectBox, TiRect rectClip = c_rectPS3Screen, float fOpacity = 1.0f) const;
  void    DrawWithFill(TiRect rectBox, SyColor32F crFill, TiRect rectClip = c_rectPS3Screen, float fOpacity = 1.0f) const;
};

#endif
