/********************************************************************

  Module: TiButtonMap

  Author: Carlo Ordonez

  Description:

    Button mappings for UI windows

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiButtonMap.h"
#include "SyAssert.h"

TiButtonMap::Button TiButtonMap::GetButton( int32 ButtonId ) const
{
  Button result = kUnknown;

  switch( mMapping )
  {
  case kAirflo:
    switch( ButtonId )
    {
    case 0:
      result = kUp;
      break;
    case 1:
      result = kRight;
      break;
    case 2:
      result = kDown;
      break;
    case 3:
      result = kLeft;
      break;
    case 4:
      result = kX;
      break;
    case 5:
      result = kCircle;
      break;
    case 6:
      result = kSquare;
      break;
    case 7:
      result = kTriangle;
      break;
    case 8:
      result = kL1;
      break;
    case 9:
      result = kR1;
      break;
    case 10:
      result = kL2;
      break;
    case 11:
      result = kR2;
      break;
    case 12:
      result = kSelect;
      break;
    case 13:
      result = kStart;
      break;
    case 14:
      result = kL3;
      break;
    case 15:
      result = kR3;
      break;
    }
  	break;

  case kLogitech:
#ifdef __CELLOS_LV2__ // PS3
    switch( ButtonId )
    {
    case 0:
      result = kUp;
      break;
    case 1:
      result = kRight;
      break;
    case 2:
      result = kDown;
      break;
    case 3:
      result = kLeft;
      break;
    case 4:
      result = kX;
      break;
    case 5:
      result = kCircle;
      break;
    case 6:
      result = kSquare;
      break;
    case 7:
      result = kTriangle;
      break;
    case 8:
      result = kL1;
      break;
    case 9:
      result = kL2;
      break;
    case 10:
      result = kR1;
      break;
    case 11:
      result = kR2;
      break;
    case 12:
      result = kStart;
      break;
    case 13:
      result = kSelect;
      break;
    case 14:
      result = kL3;
      break;
    case 15:
      result = kR3;
      break;
    }
#else
    switch( ButtonId )
    {
    case 0:
      result = kUp;
      break;
    case 1:
      result = kRight;
      break;
    case 2:
      result = kDown;
      break;
    case 3:
      result = kLeft;
      break;
    case 4:
      result = kSquare;
      break;
    case 5:
      result = kX;
      break;
    case 6:
      result = kCircle;
      break;
    case 7:
      result = kTriangle;
      break;
    case 8:
      result = kL1;
      break;
    case 9:
      result = kR1;
      break;
    case 10:
      result = kL2;
      break;
    case 11:
      result = kR2;
      break;
    case 12:
      result = kSelect;
      break;
    case 13:
      result = kStart;
      break;
    case 14:
      result = kR3;
      break;
    case 15:
      result = kL3;
      break;
    }
#endif
    break;

  case kPS2:
    switch( ButtonId )
    {
    case 0:
      result = kUp;
      break;
    case 1:
      result = kRight;
      break;
    case 2:
      result = kDown;
      break;
    case 3:
      result = kLeft;
      break;
    case 4:
      result = kTriangle;
      break;
    case 5:
      result = kCircle;
      break;
    case 6:
      result = kX;
      break;
    case 7:
      result = kSquare;
      break;
    case 8:
      result = kL2;
      break;
    case 9:
      result = kR2;
      break;
    case 10:
      result = kL1;
      break;
    case 11:
      result = kR1;
      break;
    case 12:
      result = kSelect;
      break;
    case 13:
      result = kStart;
      break;
    case 14:
      result = kR3;
      break;
    case 15:
      result = kL3;
      break;
    }
    break;

  default:
    SyAssert( 0 );
    break;
  }

  return( result );
}
