/********************************************************************

  Module: TiButtonMap

  Author: Carlo Ordonez

  Description:

    Button mappings for UI windows

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiButtonMap_h_
#define _TiButtonMap_h_

#include "SyTypes.h"

class TiButtonMap
{
public:

  enum Mapping
  {
    kAirflo,
    kLogitech,
    kPS2,
  };

  enum Button
  {
    kUnknown = -1,
    kX,
    kCircle,
    kTriangle,
    kSquare,
    kL1,
    kR1,
    kL2,
    kR2,
    kL3,
    kR3,
    kSelect,
    kStart,
    kUp,
    kDown,
    kLeft,
    kRight,
  };

  TiButtonMap() { mMapping = kAirflo; }
  ~TiButtonMap() {}

  Mapping       GetMapping() const { return( mMapping ); }
  void          SetMapping( Mapping mapping ) { mMapping = mapping; }

  Button        GetButton( int32 ButtonId ) const;

private:
  Mapping       mMapping;
};

#endif

