/********************************************************************

  Module: TiCharacterWindow

  Author: Carlo Ordonez

  Description:

    Character window (inventory, stats, skills, quests)

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiCharacterWindow_h_
#define _TiCharacterWindow_h_

#include "TiWindow.h"
#include "TiCharacterPage.h"
#include "SyCamera.h"

class TiUIControl;
class TiUILayout;
class TiCharacterData;
class Titan;
class TitanUI;



/**********************************************************
 * TiCharacterWindow
 **********************************************************/
class TiCharacterWindow : public TiWindow
{
public:
  TiCharacterWindow( TiWindow* pParent, TiCharacterData* pData );
  ~TiCharacterWindow();

  int32               Init( int32 PlayerCount, int32 Player );

  // overrides
  virtual void        DrawSelf();
  virtual bool        ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool        ProcessButtonUp( int32 DeviceId, int32 ButtonId );
  virtual void        ProcessMessage( TiWindowMessage* pMessage );
  virtual void        ProcessReloadLayout();
  virtual void        OnProcessFrame();

  void                SetGold( int32 Player, int32 Gold );

  // Lets make life easy - convenience route(s)
	int32               GetPlayerSprite (int iPlayer);

private:

  void                DrawTabs();
  void                NextPage( int32 Player );
  void                PrevPage( int32 Player );
  void                Open( int32 Player );
  void                Close( int32 Player );
  void                InitPaperDoll(int32 iPlayer);
  void                UpdatePaperDoll(float32 fElapsed);
  void                ClosePaperDoll();

  static const int32  c_nMaxLocalPlayers = 2; // local players

  bool                mbOpen[ c_nMaxLocalPlayers ];
  TiUIControl*        mpCtrl[ c_nMaxLocalPlayers ];
  TiWindow*           mpPages[ c_nMaxLocalPlayers ][ kMaxPages ];
  ECharacterPage      mePage[ c_nMaxLocalPlayers ];

  int32               miPaperDollPlayer;
  int32               mnPlayerCount;
  TiCharacterData*    mpData;
  TiPoint             mptPageLoc[c_nMaxLocalPlayers];
  TiRect              mrectPaperDolls[c_nMaxLocalPlayers];

  TiSprite            mSprPaperDollBG;
  TiSprite            mSprPersonaTabs;
  TiSprite            mSprTabs[kMaxPages];
  TiSprite            mSprPillar;
  float32             mfTabOpacity[c_nMaxLocalPlayers][kMaxPages];
	SyCamera            mCamera;
  int32	              mPaperDollSprite;
  SyTime              mLocalTime;
  float32             mPlayerHeading;

  bool					m_bReturningFromDialog;


	/*
	 * Useful pointers
	 */
  Titan    *mpTitan;
  TitanUI  *mpTitanUI;
  SyScene  *mpScene;
  SyRaster *mpRaster;
};


#endif


