/******************************************************************

  Module: TiCircleDraw.h

  Author: Jon Wiesman

  Description:

    class to draw a pie slice of a circle based on a source texture and a beginning and ending
    set of radians

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __TiCircleDraw_h__
#define __TiCircleDraw_h__

#include "TiPtSizeRect.h"
#include "SyResourceID.h"


class TiCircleDraw 
{
  enum 
  {
    c_nMaxTriangles = 8,
  };
  TiRect        m_rect;
  SyResourceID  m_idSurface;
  float32       m_fBeginSlice;  // in radians
  float32       m_fEndSlice;    // in radians

  bool          m_bValidSlice[c_nMaxTriangles];
  TiPoint       m_arSurface[c_nMaxTriangles][3];
  TiPoint       m_arScreen[c_nMaxTriangles][3];

  TiPoint       GetProjectedPoint(float32 fAngle) const;
  void          SetPoints();

public:
  TiCircleDraw();
  
  void          Init(TiRect rectScreen, const char8 *pszSurface, float32 fBegin = 0.f, float32 fEnd = 0.f);

  void          SetRect(TiRect rect);
  void          SetAngles(float32 fBegin, float32 fEnd);

  void          Draw() const;

  static TiPoint  GetProjectedPoint(TiSize size, float32 fAngle);
};

#endif
