/********************************************************************

Module: TiDialog

Author: Vince Harron

Description:

Dialog base class

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiDialog.h"
#include "SyAssert.h"
#include "TiEventLoop.h"
#include "TiApp.h"

//***********************************************************************
// Constructors
//***********************************************************************

TiDialog::TiDialog( TiApp* pApp ):
TiTopLevelWindow( pApp ),
mbIsModal(false),
mpEventLoop(0)
{
}

TiDialog::TiDialog( TiWindow* pParent ):
TiTopLevelWindow( pParent ),
mbIsModal(false),
mpEventLoop(0)
{
}

//***********************************************************************
// Destructor
//***********************************************************************

TiDialog::~TiDialog(void)
{
  delete mpEventLoop;
}

//***********************************************************************
// ShowModal
//***********************************************************************

int TiDialog::ShowModal()
{
  SyAssert( !IsModal() );
  if ( IsModal() )
  {
    return GetReturnCode();
  }

  Show(true);

  mbIsModal = true;

  SetFocus();

  if ( !mpEventLoop )
  {
    mpEventLoop = new TiEventLoop(mpApp);
  }
  mpApp->ModalStackPush(this);
  mpEventLoop->Run();

  return GetReturnCode();
}

//***********************************************************************
// EndModal
//***********************************************************************

void TiDialog::EndModal( int returnCode )
{
  SyAssert( IsModal() );
  if ( !IsModal() )
  {
    return;
  }

  mbIsModal = false;

  SetReturnCode( returnCode );

  mpEventLoop->Exit();

  Show(false);

  mpApp->ModalStackPop();

  if ( mpParent )
  {
    mpParent->SetFocus();
  }
  else
  {
    mpApp->SetFocus(0);
  }
}
