/********************************************************************

Module: TiDialog

Author: Vince Harron

Description:

Dialog base class

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiDialog_h_
#define _TiDialog_h_

#include "TiTopLevelWindow.h"

class TiEventLoop;

class TiDialog : public TiTopLevelWindow
{
public:
  TiDialog( TiApp* pApp );
  TiDialog( TiWindow* pParent );
  virtual ~TiDialog(void);

  virtual int ShowModal();
  void        EndModal( int returnCode );
  bool        IsModal() const;


private:

  void SetReturnCode( int returnCode );
  int  GetReturnCode() const;

  bool         mbIsModal;
  int          mReturnCode;
  TiEventLoop* mpEventLoop;
};



//***********************************************************************
// IsModal
//***********************************************************************
inline bool TiDialog::IsModal() const
{
	return mbIsModal;
}

//***********************************************************************
// Get/SetReturnCode
//***********************************************************************
inline int TiDialog::GetReturnCode() const
{
	return mReturnCode;
}
inline void TiDialog::SetReturnCode( int returnCode )
{
	mReturnCode = returnCode;
}

#endif // _TiDialog_h_

