/********************************************************************

Module: TiEventLoop

Author: Vince Harron

Description:

an object that represents the typical application event loop

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiEventLoop.h"
#include "TiApp.h"

TiEventLoop::TiEventLoop( TiApp* pApp ) :
mpApp(pApp),
mbIsRunning(false)
{
}

TiEventLoop::~TiEventLoop(void)
{
}

void TiEventLoop::Run()
{
  mbIsRunning = true;
  while ( mbIsRunning )
  {
    mpApp->OnFrame();
  }
}

void TiEventLoop::Exit()
{
  mbIsRunning = false;
}

