/********************************************************************

  Module: TiFocusMessage

  Author: Carlo Ordonez

  Description:

    Window focus message

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiFocusMessage_h_
#define _TiFocusMessage_h_

#include "TiWindowMessage.h"

class TiFocusMessage : public TiWindowMessage
{
public:
  TiFocusMessage( TiWindow* pSender, int32 MessageId, TiWindow* pOldWindow, TiWindow* pNewWindow )
    : TiWindowMessage( pSender, MessageId )
  {
    mpOldWindow = pOldWindow;
    mpNewWindow = pNewWindow;
  }
  ~TiFocusMessage() {}

  TiWindow*     GetOldWindow() const { return( mpOldWindow ); }
  TiWindow*     GetNewWindow() const { return( mpNewWindow ); }

private:

  TiWindow*     mpOldWindow;
  TiWindow*     mpNewWindow;
};

#endif

