/********************************************************************

Module: TiGlowyText

Author: Jon Wiesman

Description:

Draws super cool glowy text!!1! and other cheesy ui stuff

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef __TiGlowyText_h__
#define __TiGlowyText_h__

#include "SyString.h"
#include "SyColor.h"
#include "TiFPtSizeRect.h"
#include "SyRand.h"

class TiUiParticleEmitter;

class TiUiParticle
{
  bool                m_bActive;
  SyColor32F          m_crColorStart;
  SyColor32F          m_crColorEnd;
  TiFPoint            m_fptLocation;
  TiFPoint            m_fptVelocity;
  float32             m_fAge;
  float32             m_fMaxAge;
  TiUiParticleEmitter *m_pOwner;

  SyColor32F          GetColor() const;

public:
  TiUiParticle();

  bool        IsActive() const {return m_bActive;}
  void        Create(SyColor32F crStart, SyColor32F crEnd, TiFPoint fptOrigin, TiFPoint fptVelocity, 
                      float32 fMaxAge, TiUiParticleEmitter *pOwner);
  void        Kill();

  void        Update(float32 fElapsed);
  void        Draw(TiRect rectClip = c_rectPS3Screen) const;
};

class TiUiParticleEmitter
{
  enum
  {
    kMaxParticles = 256,
  };

  TiUiParticle  m_arParticles[kMaxParticles];
  TiFPoint      m_fptLocation;
  TiFPoint      m_fptVelocity;    // the emitter itself may be moving and that will affect particles
  float32       m_fGravity;       // acceleration due to gravity
  float32       m_fHeading;       // where are we pointing
  float32       m_fCone;          // how wide is the 'nozzle'
  float32       m_fEmitRate;      // particles per second
  float32       m_fMinEmitSpeed;  //
  float32       m_fMaxEmitSpeed;  // how fast particles are coming out
  float32       m_fMaxAge;        // max age of particles
  SyColor32F    m_crColorStart;
  SyColor32F    m_crColorEnd;
  float32       m_fLastEmitElapse;
  bool          m_bEmitting;
  SyRand        m_rand;

  TiUiParticle  *FindAvailableParticle();
  bool          Emit();

public:
  TiUiParticleEmitter();

  float32       GetGravity() const {return m_fGravity;}

  void          StopEmitting() {m_bEmitting = false;}
  void          StartEmitting() {m_bEmitting = true;}
  void          KillAllParticles();
  void          Update(float32 fElapsed);
  void          Draw(TiRect rectClip = c_rectPS3Screen) const;
  void          SetLocation(TiFPoint fpt) {m_fptLocation = fpt;}
  void          SetVelocity(TiFPoint fptVelocity) {m_fptVelocity = fptVelocity;}
  void          SetGravity(float32 fGravity) {m_fGravity = fGravity;}
  void          SetHeading(float32 fHeading) {m_fHeading = fHeading;}
  void          SetCone(float32 fCone) {m_fCone = fCone;}
  void          SetEmitRate(float32 fEmitRate) {m_fEmitRate = fEmitRate;}
  void          SetEmitSpeed(float32 fMin, float32 fMax) {m_fMinEmitSpeed = fMin; m_fMaxEmitSpeed = fMax;}
  void          SetNozzle(float32 fHeading, float32 fCone, float32 fRate, float32 fMinSpeed, float32 fMaxSpeed)
  {
    SetHeading(fHeading);
    SetCone(fCone);
    SetEmitRate(fRate);
    SetEmitSpeed(fMinSpeed, fMaxSpeed);
  }
  void          SetColors(const SyColor32F &crStart, const SyColor32F &crEnd)
  {
    m_crColorStart = crStart;
    m_crColorEnd = crEnd;
  }
};

class TiGlowyText
{
  
};


#endif


