/********************************************************************

  Module: TiInstaller

  Author: Vince Harron

  Description:

    Routines for mirroring file system directory trees.

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#pragma once

class TiInstaller
{
public:
  // copies a file srcPath to dstPath
  // srcPath - absolute path of source filename
  // dstPath - absolute path of destination filename
  // Returns:
  //   0 success
  //  -1 failure
  static int CopyFile( const char* srcPath, const char* dstPath );

  // recursively copies all files and directories in "srcPath" to "dstPath"
  // srcPath - absolute path of source directory
  // dstPath - absolute path of destination directory
  // Returns:
  //   0 success
  //  -1 failure
  static int CopyTree( const char* srcPath, const char* dstPath );

  // recursively prints paths of all files and directories in "directory"
  // directory - absolute path of directory holding files to be listed
  // Returns:
  //   0 success
  //  -1 failure
  static int ListTree( const char* directory );

  // recursively deletes all files and directories in "directory"
  // does NOT remove "directory"
  // directory - absolute path of directory holding files to be deletes
  // Returns:
  //   0 success
  //  -1 failure
  static int DeleteTree( const char* directory );

  // recursively deletes all files and directories in "dstPath"
  // recursively copies all files and directories in "srcPath" to "dstPath"
  // directory - absolute path of directory holding files to be deletes
  // Returns:
  //   0 success
  //  -1 failure
  static int Install( const char* srcPath, const char* dstPath );
};
