/********************************************************************

Module: TiJWCommandHandler

Author: Jon Wiesman

Description:

This class registers itself as a command handler with an ID.  
Whenever anyone types a string into the command console with that ID prepended,
the console window passes that string to this class for processing.

Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiJWComanndHandler.h"
#include "TitanI.h"
#include "TitanUI.h"

static TiJWCommandHandler s_myHandler;

TiJWCommandHandler::TiJWCommandHandler() : TiConsoleCommandHandler()
{
}

void TiJWCommandHandler::ProcessConsoleCommand(const SyString &str)
{
  if(str.CompareWithoutCase("lbon") == 0)
  {
    TitanUI::Instance()->BeginLetterbox();
  }
  if(str.CompareWithoutCase("lboff") == 0)
  {
    TitanUI::Instance()->EndLetterbox();
  }
  if(str.CompareWithoutCase("reload") == 0)
  {
	  TitanUI::Instance()->UpdateCharacterData();
  }

  SyVector<SyString> arTokens;
  int32 nCount = TokenizeString(str, arTokens);

  if(nCount >= 1 && arTokens(0).CompareWithoutCase("fadeout") == 0)
  {
    float32 fTrans = 1.f;
    if(nCount >= 2)
      fTrans = (float)atof(arTokens(1).AsChar());

    TitanUI::Instance()->FadeOut(fTrans);
  }
  if(nCount >= 1 && arTokens(0).CompareWithoutCase("fadein") == 0)
  {
    float32 fTrans = 1.f;
    if(nCount >= 2)
      fTrans = (float)atof(arTokens(1).AsChar());

    TitanUI::Instance()->FadeIn(fTrans);
  }
  if(nCount >= 1 && arTokens(0).CompareWithoutCase("fadeandexit") == 0)
  {
    float32 fDelay = 0.f;
    float32 fFade = 0.f;
    if(nCount >= 2)
      fDelay = (float)atof(arTokens(1).AsChar());
    if(nCount >= 3)
      fFade = (float)atof(arTokens(2).AsChar());
    TitanUI::Instance()->FadeAndExit(fDelay, fFade);
  }
  if(nCount >= 2 && arTokens(0).CompareWithoutCase("gimme") == 0)
  {
    int32 nItemCount = 1;
    int32 iPlayer = 0;
    if(nCount == 3)
      iPlayer = atoi(arTokens(2).AsChar());
    if(nCount == 4)
      nItemCount = atoi(arTokens(3).AsChar());

    for(int i = 0; i < nItemCount; i++)
    {
      sm_pTitanI->Debug_AddItemToPlayerInventory(iPlayer, arTokens(1).AsChar());
    }
  }

  
}

