/********************************************************************

  Module: TiKeyboard

  Author: Carlo Ordonez

  Description:

    Virtual keyboard

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiKeyboard_h_
#define _TiKeyboard_h_

#include "TiWindow.h"
#include "SyString.h"

class TiUIControl;

class TiKeyboard : public TiWindow
{
public:
  TiKeyboard( TiWindow* pParent );
  ~TiKeyboard();

  void                SetTitle( const char8* pTitle );
  const char8*        GetTitle() const;

  void                SetMaxLen( int32 MaxLen );
  int32               GetMaxLen() const;

  void                SetText( const char8* pText );
  const char8*        GetText() const;

  // overrides
  virtual void        DrawSelf();
  virtual bool        ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool        ProcessButtonUp( int32 DeviceId, int32 ButtonId );
  virtual void        ProcessMessage( TiWindowMessage* pMessage );
  virtual bool        IsVisible() const;
  virtual void        Show( bool Visible );

  static const int32  sRows     = 6;
  static const int32  sColumns  = 6;
  static const int32  sTextMax  = 256;

private:

  void        Move( int32 X, int32 Y );
  void        Select();
  void        Backspace();
  void        Accept();

private:

  TiUIControl*        mpCtrl;
  int32               mPlayerId; // who has me open?
  int32               mRow;
  int32               mCol;
  char8               mText[sTextMax];
  SyString            mTitle;
  int32               mMaxLen;
  bool                mShiftDown;
};

#endif

