/********************************************************************

Module: TiLoadSaveGameWindow

Author: Christian Ebbecke

Description:

Temp window for loading/saving of games

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiLoadSaveGameWindow_h_
#define _TiLoadSaveGameWindow_h_

#include "TiWindow.h"
#include "TiBoxDraw.h"
#include "TiChildFrameDraw.h"

class TiUIControl;


//-----------------------------------------------------------------------
class TiLoadSaveGameWindow : public TiWindow
{
public:
	TiLoadSaveGameWindow( TiWindow* pParent );
	~TiLoadSaveGameWindow();

	void				Init( bool bForLoading );

	// overrides
	virtual void        DrawSelf();
	virtual bool        ProcessButtonDown( int32 DeviceId, int32 ButtonId );
	virtual void        ProcessMessage( TiWindowMessage* pMessage );

private:

	void				NextSelection();
	void				PrevSelection();
	void				Close();
	void                Select();
	void                NewGame();

private:

	TiUIControl*        mpCtrl;
	int32               mSelection;
	int32				mForLoading;

	TiBoxDraw			m_bdSelection;
	TiChildFrameDraw	m_cfd;
};

#endif

