/********************************************************************

  Module: TiMenu

  Author: Carlo Ordonez

  Description:

    Game menu classes

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiMenu_h_
#define _TiMenu_h_

#include "SyTypes.h"
#include "SyString.h"
#include <vector>

class TiMenu;
class TiMenuItem
{
public:
  enum Type
  {
    kSeperator,
    kNormal,
    kRadio,
    kCheck,
    kMax
  };

  TiMenuItem( TiMenu* pParent, int32 Id, const char8* pText, Type type, TiMenu* pSubmenu );
  ~TiMenuItem();

  void          SetCheck( bool Check ) { mChecked = Check; }
  bool          GetCheck() const { return( mChecked ); }

public:

  static const int32 TEXT_LEN = 64;

  TiMenu*       mpParent;
  int32         mId;
  char8         mText[TEXT_LEN];
  Type          mType;
  TiMenu*       mpSubmenu;
  bool          mChecked;
};

class TiMenu
{
public:
  TiMenu();
  ~TiMenu();

  int32   Init( TiMenu* pParent, const char8* pTitle );
  void    AddItem( int32 Id, const char8* pText, TiMenuItem::Type Type, TiMenu* pSubmenu );

  void    SetCheck( int32 MenuItemId, bool Check );
  bool    GetCheck( int32 MenuItemId ) const;
  void    SetItemText( int32 MenuItemId, const char8 *pText);

  void    Next();
  void    Prev();
  int32   Find( int32 MenuItemId );

  TiMenu* mpParent;
  int32 mSelection;
  int32 mScroll;
  int32 mWrapSelections;
  SyString mTitle;
  std::vector< TiMenuItem > mMenuItems;
};

#endif

