/********************************************************************

  Module: TiMessageBox

  Author: Carlo Ordonez

  Description:

    Message Box Dialog

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiMessageBox_h_
#define _TiMessageBox_h_

#include "TiDialog.h"
#include "SyString.h"
#include "SyVect2I.h"

class TiUIControl;

class TiMessageBox : public TiDialog
{
public:
  enum Type
  {
    kAbortRetryIgnore,
    kOk,
    kOkCancel,
    kRetryCancel,
    kYesNo,
    kYesNoCancel
  };

  enum ReturnCode
  {
    kIdAbort,
    kIdCancel,
    kIdIgnore,
    kIdNo,
    kIdOk,
    kIdRetry,
    kIdYes
  };

  TiMessageBox( TiApp* pApp, const char8* pText, const char8* pCaption, Type type = kOk );
  TiMessageBox( TiWindow* pParent, const char8* pText, const char8* pCaption, Type type = kOk );
  ~TiMessageBox();

  virtual void  DrawSelf();
  virtual bool  ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual void  ProcessMessage( TiWindowMessage* pMessage );

  void			SetWidth( int32 nWidth ) { m_nWidth = nWidth; }
  void			SetCenterPoint( const SyVect2I& pt ) { m_vCenterPoint = pt; }

private:

  SyString      mText;
  SyString      mCaption; // title
  Type          mType;
  TiUIControl*  mpCtrl;

  SyVect2I		m_vCenterPoint;
  int32			m_nWidth;
};

#endif

