/********************************************************************

  Module: TiNewCharacterWindow

  Author: Carlo Ordonez

  Description:

    Character creation window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiNewCharacterWindow_h_
#define _TiNewCharacterWindow_h_

#include "TiWindow.h"

#define ID_NEW_CHARACTER            (wxID_HIGHEST + 0x0d00)

class TiClassWindow;
class TiAppearanceWindow;
class TiAttributeWindow;
class TiNameWindow;

class TiNewCharacterWindow : public TiWindow
{
public:
  TiNewCharacterWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("NewCharacter"), int WindowId = ID_NEW_CHARACTER );
  ~TiNewCharacterWindow();

private:

  void        OnKeyDown( wxKeyEvent& event );
  void        OnSize( wxSizeEvent& event );
  void        OnPaint( wxPaintEvent& event );
  void        OnEraseBackground( wxEraseEvent& event );
  void        OnSetFocus( wxFocusEvent& event );

  enum Mode
  {
    kClass,       // brute/knight/mage
    kAppearance,  // customize appearance
    kAttributes,  // allocate attribute points
    kName         // set character's name
  };

  void                Back();
  void                Next();
  void                SetMode( Mode NewMode );

  Mode                mMode;
  TiClassWindow*      mpClass;
  TiAppearanceWindow* mpAppearance;
  TiAttributeWindow*  mpAttributes;
  TiNameWindow*       mpName;

  DECLARE_CLASS( TiNewCharacterWindow )
  DECLARE_EVENT_TABLE();
};

#endif

