/********************************************************************

  Module: TiPawnOutput

  Author: Carlo Ordonez

  Description:

    Pawn Output Window

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiPawnOutput.h"
#include "TiUIControl.h"
#include "TiUI.h"

//***********************************************************************
// Constructor/Destructor
//***********************************************************************

TiPawnOutput::TiPawnOutput( TiWindow* pParent )
: TiWindow( pParent )
{
  mpCtrl = SyNew TiUIControl();
}

TiPawnOutput::~TiPawnOutput()
{
  delete mpCtrl;
}

//***********************************************************************
// DrawSelf
//***********************************************************************

void TiPawnOutput::DrawSelf()
{
  int32 w, h;
  TiUI::Instance()->GetDisplaySize( &w, &h );

  // frame dimensions
  int32 rows = 6;
  int32 width = w >> 1;
  int32 margin = 20;
  SyVect2I center( w >> 1, 125 );

  // text box dimensions
  int32 lines = rows - 2;
  int32 tbWidth = width-(margin<<1);

  // scroll
  int32 offset = 0;
  int32 count = mpCtrl->CountLines( mText.AsChar(), tbWidth );
  if( count > lines )
  {
    offset = count-lines;
  }

  mpCtrl->Init( center, width, rows, TiUIControl::kBlack );
  mpCtrl->SetOpacity( .4f );
  mpCtrl->Draw();
  mpCtrl->DrawTextBox( mText, margin, 1, tbWidth, lines, TiUIControl::kNormal, TI_TF_LINE_OFFSET(offset) );
}

//***********************************************************************
// Output
//***********************************************************************

void TiPawnOutput::Output( const char8* pText )
{
  mText.Concat( pText );
  mText.Concat( '\n' );
}
