/********************************************************************

  Module: TiStartMessage

  Author: Carlo Ordonez

  Description:

    Messages coming from the front screen

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiStartMessage_h_
#define _TiStartMessage_h_

#include "TiCommandMessage.h"

static const int32 TI_START_GO            = 0;
static const int32 TI_START_NEW_GAME      = 1;
static const int32 TI_START_LOAD_GAME     = 2;

class TiStartMessage : public TiCommandMessage
{
public:
  TiStartMessage( TiWindow* pSender, int32 StartMessageId )
    : TiCommandMessage( pSender, TIWINDOW_COMMAND, TI_CMD_START, false )
	, mLoadGame( -1 )
  {
    mStartMessageId = StartMessageId;
  }

  int32     GetStartMessageId() const { return( mStartMessageId ); }
  
  void      SetInternet( bool Internet ) { mInternet = Internet; }
  bool      GetInternet() const { return( mInternet ); }

  void      SetPlayers( int32 Players ) { mPlayers = Players; }
  int32     GetPlayers() const { return( mPlayers ); }

  void      SetCampaign( bool Campaign ) { mCampaign = Campaign; }
  bool      GetCampaign() const { return( mCampaign ); }

  void      SetDifficulty( int32 Difficulty ) { mDifficulty = Difficulty; }
  int32     GetDifficulty() const { return( mDifficulty ); }

  void      SetClass( int32 Class ) { mClass = Class; }
  int32     GetClass() const { return( mClass ); }

  void      SetLoadGame( int32 Index ) { mLoadGame = Index; }
  int32     GetLoadGame() const { return( mLoadGame ); }

  void      SetName( const SyString& Name ) { mName = Name; }
  const SyString& GetName() const { return( mName ); }

private:

  int32     mStartMessageId;

  // new game info
  bool      mInternet;
  int32     mPlayers;
  bool      mCampaign;
  int32     mDifficulty;
  int32     mClass;       // todo: other players
  SyString  mName;        // todo: other players
  int32		mLoadGame;
};

#endif

